/*
* padmux_tables.c- Sigmastar
*
* Copyright (c) [2019~2020] SigmaStar Technology.
*
*
* This software is licensed under the terms of the GNU General Public
* License version 2, as published by the Free Software Foundation, and
* may be copied, distributed, and modified under those terms.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License version 2 for more details.
*
*/
#include "gpio.h"
#include "padmux.h"
#include "padmux_tables.h"
#include "chiptop_reg.h"
#include "pmsleep_reg.h"

//==============================================================================
//
//                              padmux_table
//
//==============================================================================
const ST_PadMuxInfo m_stPadMuxTbl[] =
{
    {PAD_GPIO0, CHIPTOP_BANK, REG_SPI0_MODE,            REG_SPI0_MODE_MASK,         BIT2|BIT1,      PINMUX_FOR_SPI0_MODE_6},
    {PAD_GPIO0, CHIPTOP_BANK, REG_FUART_MODE,           REG_FUART_MODE_MASK,        BIT2|BIT0,      PINMUX_FOR_FUART_MODE_5},
    {PAD_GPIO0, CHIPTOP_BANK, REG_PWM0_MODE,            REG_PWM0_MODE_MASK,         BIT0,           PINMUX_FOR_PWM0_MODE_1},
    {PAD_GPIO0, CHIPTOP_BANK, REG_ETH1_MODE,            REG_ETH1_MODE_MASK,         BIT10,          PINMUX_FOR_ETH1_MODE_4},
    {PAD_GPIO0, CHIPTOP_BANK, REG_ETH1_MODE,            REG_ETH1_MODE_MASK,         BIT10|BIT8,     PINMUX_FOR_ETH1_MODE_5},
    {PAD_GPIO0, CHIPTOP_BANK, REG_ETH1_MODE,            REG_ETH1_MODE_MASK,         BIT11,          PINMUX_FOR_ETH1_MODE_8},
    {PAD_GPIO0, CHIPTOP_BANK, REG_I2S_MODE,             REG_I2S_MODE_MASK,          BIT12,          PINMUX_FOR_I2S_MODE_1},

    {PAD_GPIO1, CHIPTOP_BANK, REG_SPI0_MODE,            REG_SPI0_MODE_MASK,         BIT2|BIT1,      PINMUX_FOR_SPI0_MODE_6},
    {PAD_GPIO1, CHIPTOP_BANK, REG_FUART_MODE,           REG_FUART_MODE_MASK,        BIT2|BIT0,      PINMUX_FOR_FUART_MODE_5},
    {PAD_GPIO1, CHIPTOP_BANK, REG_PWM1_MODE,            REG_PWM1_MODE_MASK,         BIT3,           PINMUX_FOR_PWM1_MODE_1},
    {PAD_GPIO1, CHIPTOP_BANK, REG_ETH1_MODE,            REG_ETH1_MODE_MASK,         BIT10,          PINMUX_FOR_ETH1_MODE_4},
    {PAD_GPIO1, CHIPTOP_BANK, REG_ETH1_MODE,            REG_ETH1_MODE_MASK,         BIT10|BIT8,     PINMUX_FOR_ETH1_MODE_5},
    {PAD_GPIO1, CHIPTOP_BANK, REG_ETH1_MODE,            REG_ETH1_MODE_MASK,         BIT11,          PINMUX_FOR_ETH1_MODE_8},
    {PAD_GPIO1, CHIPTOP_BANK, REG_I2S_MODE,             REG_I2S_MODE_MASK,          BIT12,          PINMUX_FOR_I2S_MODE_1},

    {PAD_GPIO2, CHIPTOP_BANK, REG_I2C1_MODE,            REG_I2C1_MODE_MASK,         BIT4,           PINMUX_FOR_I2C1_MODE_1},
    {PAD_GPIO2, CHIPTOP_BANK, REG_SPI0_MODE,            REG_SPI0_MODE_MASK,         BIT2|BIT1,      PINMUX_FOR_SPI0_MODE_6},
    {PAD_GPIO2, CHIPTOP_BANK, REG_FUART_MODE,           REG_FUART_MODE_MASK,        BIT2|BIT0,      PINMUX_FOR_FUART_MODE_5},
    {PAD_GPIO2, CHIPTOP_BANK, REG_PWM2_MODE,            REG_PWM2_MODE_MASK,         BIT6,           PINMUX_FOR_PWM2_MODE_1},
    {PAD_GPIO2, CHIPTOP_BANK, REG_I2S_MODE,             REG_I2S_MODE_MASK,          BIT12,          PINMUX_FOR_I2S_MODE_1},

    {PAD_GPIO3, CHIPTOP_BANK, REG_I2C1_MODE,            REG_I2C1_MODE_MASK,         BIT4,           PINMUX_FOR_I2C1_MODE_1},
    {PAD_GPIO3, CHIPTOP_BANK, REG_SPI0_MODE,            REG_SPI0_MODE_MASK,         BIT2|BIT1,      PINMUX_FOR_SPI0_MODE_6},
    {PAD_GPIO3, CHIPTOP_BANK, REG_FUART_MODE,           REG_FUART_MODE_MASK,        BIT2|BIT0,      PINMUX_FOR_FUART_MODE_5},
    {PAD_GPIO3, CHIPTOP_BANK, REG_PWM3_MODE,            REG_PWM3_MODE_MASK,         BIT9,           PINMUX_FOR_PWM3_MODE_1},
    {PAD_GPIO3, CHIPTOP_BANK, REG_I2S_MODE,             REG_I2S_MODE_MASK,          BIT12,          PINMUX_FOR_I2S_MODE_1},

    {PAD_GPIO4, CHIPTOP_BANK, REG_EJ_MODE,              REG_EJ_MODE_MASK,           BIT1|BIT0,      PINMUX_FOR_EJ_MODE_3},
    {PAD_GPIO4, CHIPTOP_BANK, REG_PM_SPICZ2_MODE,       REG_PM_SPICZ2_MODE_MASK,    BIT4,           PINMUX_FOR_PM_SPICZ2_MODE_1},
    {PAD_GPIO4, CHIPTOP_BANK, REG_SPI0_MODE,            REG_SPI0_MODE_MASK,         BIT1|BIT0,      PINMUX_FOR_SPI0_MODE_3},
    {PAD_GPIO4, CHIPTOP_BANK, REG_FUART_MODE,           REG_FUART_MODE_MASK,        BIT2|BIT1,      PINMUX_FOR_FUART_MODE_6},
    {PAD_GPIO4, CHIPTOP_BANK, REG_SDIO_MODE,            REG_SDIO_MODE_MASK,         BIT9,           PINMUX_FOR_SDIO_MODE_2},
    {PAD_GPIO4, CHIPTOP_BANK, REG_PWM0_MODE,            REG_PWM0_MODE_MASK,         BIT1|BIT0,      PINMUX_FOR_PWM0_MODE_3},
    {PAD_GPIO4, CHIPTOP_BANK, REG_DMIC_MODE,            REG_DMIC_MODE_MASK,         BIT9|BIT8,      PINMUX_FOR_DMIC_MODE_3},

    {PAD_GPIO5, CHIPTOP_BANK, REG_EJ_MODE,              REG_EJ_MODE_MASK,           BIT1|BIT0,      PINMUX_FOR_EJ_MODE_3},
    {PAD_GPIO5, CHIPTOP_BANK, REG_SPI0_MODE,            REG_SPI0_MODE_MASK,         BIT1|BIT0,      PINMUX_FOR_SPI0_MODE_3},
    {PAD_GPIO5, CHIPTOP_BANK, REG_FUART_MODE,           REG_FUART_MODE_MASK,        BIT2|BIT1,      PINMUX_FOR_FUART_MODE_6},
    {PAD_GPIO5, CHIPTOP_BANK, REG_SDIO_MODE,            REG_SDIO_MODE_MASK,         BIT9,           PINMUX_FOR_SDIO_MODE_2},
    {PAD_GPIO5, CHIPTOP_BANK, REG_PWM1_MODE,            REG_PWM1_MODE_MASK,         BIT5,           PINMUX_FOR_PWM1_MODE_4},
    {PAD_GPIO5, CHIPTOP_BANK, REG_DMIC_MODE,            REG_DMIC_MODE_MASK,         BIT9|BIT8,      PINMUX_FOR_DMIC_MODE_3},

    {PAD_GPIO6, CHIPTOP_BANK, REG_EJ_MODE,              REG_EJ_MODE_MASK,           BIT1|BIT0,      PINMUX_FOR_EJ_MODE_3},
    {PAD_GPIO6, CHIPTOP_BANK, REG_I2C0_MODE,            REG_I2C0_MODE_MASK,         BIT2,           PINMUX_FOR_I2C0_MODE_4},
    {PAD_GPIO6, CHIPTOP_BANK, REG_SPI0_MODE,            REG_SPI0_MODE_MASK,         BIT1|BIT0,      PINMUX_FOR_SPI0_MODE_3},
    {PAD_GPIO6, CHIPTOP_BANK, REG_SDIO_MODE,            REG_SDIO_MODE_MASK,         BIT9,           PINMUX_FOR_SDIO_MODE_2},
    {PAD_GPIO6, CHIPTOP_BANK, REG_DMIC_MODE,            REG_DMIC_MODE_MASK,         BIT9|BIT8,      PINMUX_FOR_DMIC_MODE_3},

    {PAD_GPIO7, CHIPTOP_BANK, REG_EJ_MODE,              REG_EJ_MODE_MASK,           BIT1|BIT0,      PINMUX_FOR_EJ_MODE_3},
    {PAD_GPIO7, CHIPTOP_BANK, REG_I2C0_MODE,            REG_I2C0_MODE_MASK,         BIT2,           PINMUX_FOR_I2C0_MODE_4},
    {PAD_GPIO7, CHIPTOP_BANK, REG_SPI0_MODE,            REG_SPI0_MODE_MASK,         BIT1|BIT0,      PINMUX_FOR_SPI0_MODE_3},
    {PAD_GPIO7, CHIPTOP_BANK, REG_SDIO_MODE,            REG_SDIO_MODE_MASK,         BIT9,           PINMUX_FOR_SDIO_MODE_2},
    {PAD_GPIO7, CHIPTOP_BANK, REG_PWM3_MODE,            REG_PWM3_MODE_MASK,         BIT10,          PINMUX_FOR_PWM3_MODE_2},

    {PAD_GPIO8, CHIPTOP_BANK, REG_SPI0_MODE,            REG_SPI0_MODE_MASK,         BIT2|BIT0,      PINMUX_FOR_SPI0_MODE_5},
    {PAD_GPIO8, CHIPTOP_BANK, REG_UART0_MODE,           REG_UART0_MODE_MASK,        BIT6,           PINMUX_FOR_UART0_MODE_4},
    {PAD_GPIO8, CHIPTOP_BANK, REG_UART2_MODE,           REG_UART2_MODE_MASK,        BIT13,          PINMUX_FOR_UART2_MODE_2},
    {PAD_GPIO8, CHIPTOP_BANK, REG_SDIO_MODE,            REG_SDIO_MODE_MASK,         BIT9,           PINMUX_FOR_SDIO_MODE_2},

    {PAD_GPIO9, CHIPTOP_BANK, REG_SPI0_MODE,            REG_SPI0_MODE_MASK,         BIT2|BIT0,      PINMUX_FOR_SPI0_MODE_5},
    {PAD_GPIO9, CHIPTOP_BANK, REG_UART0_MODE,           REG_UART0_MODE_MASK,        BIT6,           PINMUX_FOR_UART0_MODE_4},
    {PAD_GPIO9, CHIPTOP_BANK, REG_UART2_MODE,           REG_UART2_MODE_MASK,        BIT13,          PINMUX_FOR_UART2_MODE_2},
    {PAD_GPIO9, CHIPTOP_BANK, REG_SDIO_MODE,            REG_SDIO_MODE_MASK,         BIT9,           PINMUX_FOR_SDIO_MODE_2},

    {PAD_GPIO10, CHIPTOP_BANK, REG_SPI0_MODE,            REG_SPI0_MODE_MASK,         BIT2|BIT0,      PINMUX_FOR_SPI0_MODE_5},
    {PAD_GPIO10, CHIPTOP_BANK, REG_UART1_MODE,           REG_UART1_MODE_MASK,        BIT10,          PINMUX_FOR_UART1_MODE_4},

    {PAD_GPIO11, CHIPTOP_BANK, REG_SPI0_MODE,            REG_SPI0_MODE_MASK,         BIT2|BIT0,      PINMUX_FOR_SPI0_MODE_5},
    {PAD_GPIO11, CHIPTOP_BANK, REG_UART1_MODE,           REG_UART1_MODE_MASK,        BIT10,          PINMUX_FOR_UART1_MODE_4},
    {PAD_GPIO11, CHIPTOP_BANK, REG_PWM2_MODE,            REG_PWM2_MODE_MASK,         BIT7,           PINMUX_FOR_PWM2_MODE_2},

    {PAD_GPIO12, CHIPTOP_BANK, REG_PWM3_MODE,            REG_PWM3_MODE_MASK,         BIT10|BIT9,     PINMUX_FOR_PWM3_MODE_3},

    {PAD_GPIO13, CHIPTOP_BANK, REG_UART1_MODE,           REG_UART1_MODE_MASK,        BIT9|BIT8,      PINMUX_FOR_UART1_MODE_3},

    {PAD_GPIO14, CHIPTOP_BANK, REG_UART1_MODE,           REG_UART1_MODE_MASK,        BIT9|BIT8,      PINMUX_FOR_UART1_MODE_3},
    {PAD_GPIO14, CHIPTOP_BANK, REG_PWM0_MODE,            REG_PWM0_MODE_MASK,         BIT2,           PINMUX_FOR_PWM0_MODE_4},

    {PAD_FUART_RX, CHIPTOP_BANK, REG_EJ_MODE,              REG_EJ_MODE_MASK,           BIT0,           PINMUX_FOR_EJ_MODE_1},
    {PAD_FUART_RX, CHIPTOP_BANK, REG_TEST_IN_MODE,         REG_TEST_IN_MODE_MASK,      BIT0,           PINMUX_FOR_TEST_IN_MODE_1},
    {PAD_FUART_RX, CHIPTOP_BANK, REG_TEST_OUT_MODE,        REG_TEST_OUT_MODE_MASK,     BIT4,           PINMUX_FOR_TEST_OUT_MODE_1},
    {PAD_FUART_RX, CHIPTOP_BANK, REG_SPI0_MODE,            REG_SPI0_MODE_MASK,         BIT2,           PINMUX_FOR_SPI0_MODE_4},
    {PAD_FUART_RX, CHIPTOP_BANK, REG_FUART_MODE,           REG_FUART_MODE_MASK,        BIT0,           PINMUX_FOR_FUART_MODE_1},
    {PAD_FUART_RX, CHIPTOP_BANK, REG_FUART_MODE,           REG_FUART_MODE_MASK,        BIT1,           PINMUX_FOR_FUART_MODE_2},
    {PAD_FUART_RX, CHIPTOP_BANK, REG_UART2_MODE,           REG_UART2_MODE_MASK,        BIT12,          PINMUX_FOR_UART2_MODE_1},
    {PAD_FUART_RX, CHIPTOP_BANK, REG_PWM3_MODE,            REG_PWM3_MODE_MASK,         BIT11|BIT9,     PINMUX_FOR_PWM3_MODE_5},
    {PAD_FUART_RX, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT10|BIT9,     PINMUX_FOR_TTL_MODE_6},
    {PAD_FUART_RX, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT10,    PINMUX_FOR_TTL_MODE_12},
    {PAD_FUART_RX, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT10|BIT8,PINMUX_FOR_TTL_MODE_13},

    {PAD_FUART_TX, CHIPTOP_BANK, REG_EJ_MODE,              REG_EJ_MODE_MASK,           BIT0,           PINMUX_FOR_EJ_MODE_1},
    {PAD_FUART_TX, CHIPTOP_BANK, REG_TEST_IN_MODE,         REG_TEST_IN_MODE_MASK,      BIT0,           PINMUX_FOR_TEST_IN_MODE_1},
    {PAD_FUART_TX, CHIPTOP_BANK, REG_TEST_OUT_MODE,        REG_TEST_OUT_MODE_MASK,     BIT4,           PINMUX_FOR_TEST_OUT_MODE_1},
    {PAD_FUART_TX, CHIPTOP_BANK, REG_SPI0_MODE,            REG_SPI0_MODE_MASK,         BIT2,           PINMUX_FOR_SPI0_MODE_4},
    {PAD_FUART_TX, CHIPTOP_BANK, REG_FUART_MODE,           REG_FUART_MODE_MASK,        BIT0,           PINMUX_FOR_FUART_MODE_1},
    {PAD_FUART_TX, CHIPTOP_BANK, REG_FUART_MODE,           REG_FUART_MODE_MASK,        BIT1,           PINMUX_FOR_FUART_MODE_2},
    {PAD_FUART_TX, CHIPTOP_BANK, REG_UART2_MODE,           REG_UART2_MODE_MASK,        BIT12,          PINMUX_FOR_UART2_MODE_1},
    {PAD_FUART_TX, CHIPTOP_BANK, REG_PWM2_MODE,            REG_PWM2_MODE_MASK,         BIT8|BIT6,      PINMUX_FOR_PWM2_MODE_5},
    {PAD_FUART_TX, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT10|BIT9,     PINMUX_FOR_TTL_MODE_6},
    {PAD_FUART_TX, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT10,    PINMUX_FOR_TTL_MODE_12},
    {PAD_FUART_TX, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT10|BIT8,PINMUX_FOR_TTL_MODE_13},

    {PAD_FUART_CTS, CHIPTOP_BANK, REG_EJ_MODE,              REG_EJ_MODE_MASK,           BIT0,           PINMUX_FOR_EJ_MODE_1},
    {PAD_FUART_CTS, CHIPTOP_BANK, REG_TEST_IN_MODE,         REG_TEST_IN_MODE_MASK,      BIT0,           PINMUX_FOR_TEST_IN_MODE_1},
    {PAD_FUART_CTS, CHIPTOP_BANK, REG_TEST_IN_MODE,         REG_TEST_IN_MODE_MASK,      BIT1|BIT0,      PINMUX_FOR_TEST_IN_MODE_3},
    {PAD_FUART_CTS, CHIPTOP_BANK, REG_TEST_OUT_MODE,        REG_TEST_OUT_MODE_MASK,     BIT4,           PINMUX_FOR_TEST_OUT_MODE_1},
    {PAD_FUART_CTS, CHIPTOP_BANK, REG_TEST_OUT_MODE,        REG_TEST_OUT_MODE_MASK,     BIT5|BIT4,      PINMUX_FOR_TEST_OUT_MODE_3},
    {PAD_FUART_CTS, CHIPTOP_BANK, REG_I2C1_MODE,            REG_I2C1_MODE_MASK,         BIT5|BIT4,      PINMUX_FOR_I2C1_MODE_3},
    {PAD_FUART_CTS, CHIPTOP_BANK, REG_SPI0_MODE,            REG_SPI0_MODE_MASK,         BIT2,           PINMUX_FOR_SPI0_MODE_4},
    {PAD_FUART_CTS, CHIPTOP_BANK, REG_FUART_MODE,           REG_FUART_MODE_MASK,        BIT0,           PINMUX_FOR_FUART_MODE_1},
    {PAD_FUART_CTS, CHIPTOP_BANK, REG_UART0_MODE,           REG_UART0_MODE_MASK,        BIT5,           PINMUX_FOR_UART0_MODE_2},
    {PAD_FUART_CTS, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT10|BIT9,     PINMUX_FOR_TTL_MODE_6},
    {PAD_FUART_CTS, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT10,    PINMUX_FOR_TTL_MODE_12},
    {PAD_FUART_CTS, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT10|BIT8,PINMUX_FOR_TTL_MODE_13},

    {PAD_FUART_RTS, CHIPTOP_BANK, REG_EJ_MODE,              REG_EJ_MODE_MASK,           BIT0,           PINMUX_FOR_EJ_MODE_1},
    {PAD_FUART_RTS, CHIPTOP_BANK, REG_TEST_IN_MODE,         REG_TEST_IN_MODE_MASK,      BIT0,           PINMUX_FOR_TEST_IN_MODE_1},
    {PAD_FUART_RTS, CHIPTOP_BANK, REG_TEST_IN_MODE,         REG_TEST_IN_MODE_MASK,      BIT1|BIT0,      PINMUX_FOR_TEST_IN_MODE_3},
    {PAD_FUART_RTS, CHIPTOP_BANK, REG_TEST_OUT_MODE,        REG_TEST_OUT_MODE_MASK,     BIT4,           PINMUX_FOR_TEST_OUT_MODE_1},
    {PAD_FUART_RTS, CHIPTOP_BANK, REG_TEST_OUT_MODE,        REG_TEST_OUT_MODE_MASK,     BIT5|BIT4,      PINMUX_FOR_TEST_OUT_MODE_3},
    {PAD_FUART_RTS, CHIPTOP_BANK, REG_I2C1_MODE,            REG_I2C1_MODE_MASK,         BIT5|BIT4,      PINMUX_FOR_I2C1_MODE_3},
    {PAD_FUART_RTS, CHIPTOP_BANK, REG_PM_SPICZ2_MODE,       REG_PM_SPICZ2_MODE_MASK,    BIT5,           PINMUX_FOR_PM_SPICZ2_MODE_2},
    {PAD_FUART_RTS, CHIPTOP_BANK, REG_SPI0_MODE,            REG_SPI0_MODE_MASK,         BIT2,           PINMUX_FOR_SPI0_MODE_4},
    {PAD_FUART_RTS, CHIPTOP_BANK, REG_FUART_MODE,           REG_FUART_MODE_MASK,        BIT0,           PINMUX_FOR_FUART_MODE_1},
    {PAD_FUART_RTS, CHIPTOP_BANK, REG_UART0_MODE,           REG_UART0_MODE_MASK,        BIT5,           PINMUX_FOR_UART0_MODE_2},
    {PAD_FUART_RTS, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT10|BIT9,     PINMUX_FOR_TTL_MODE_6},
    {PAD_FUART_RTS, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT10,    PINMUX_FOR_TTL_MODE_12},
    {PAD_FUART_RTS, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT10|BIT8,PINMUX_FOR_TTL_MODE_13},

    {PAD_TTL0, CHIPTOP_BANK, REG_TEST_IN_MODE,         REG_TEST_IN_MODE_MASK,      BIT1|BIT0,      PINMUX_FOR_TEST_IN_MODE_3},
    {PAD_TTL0, CHIPTOP_BANK, REG_TEST_OUT_MODE,        REG_TEST_OUT_MODE_MASK,     BIT5|BIT4,      PINMUX_FOR_TEST_OUT_MODE_3},
    {PAD_TTL0, CHIPTOP_BANK, REG_FUART_MODE,           REG_FUART_MODE_MASK,        BIT1|BIT0,      PINMUX_FOR_FUART_MODE_3},
    {PAD_TTL0, CHIPTOP_BANK, REG_PWM0_MODE,            REG_PWM0_MODE_MASK,         BIT2|BIT0,      PINMUX_FOR_PWM0_MODE_5},
    {PAD_TTL0, CHIPTOP_BANK, REG_DMIC_MODE,            REG_DMIC_MODE_MASK,         BIT8,           PINMUX_FOR_DMIC_MODE_1},
    {PAD_TTL0, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT8,           PINMUX_FOR_TTL_MODE_1},
    {PAD_TTL0, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT9|BIT8,      PINMUX_FOR_TTL_MODE_3},
    {PAD_TTL0, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT10,          PINMUX_FOR_TTL_MODE_4},
    {PAD_TTL0, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT10|BIT9|BIT8,PINMUX_FOR_TTL_MODE_7},
    {PAD_TTL0, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11,          PINMUX_FOR_TTL_MODE_8},
    {PAD_TTL0, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT8,     PINMUX_FOR_TTL_MODE_9},
    {PAD_TTL0, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT9,     PINMUX_FOR_TTL_MODE_10},
    {PAD_TTL0, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT9|BIT8,PINMUX_FOR_TTL_MODE_11},
    {PAD_TTL0, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT10,    PINMUX_FOR_TTL_MODE_12},
    {PAD_TTL0, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT10|BIT8,PINMUX_FOR_TTL_MODE_13},

    {PAD_TTL1, CHIPTOP_BANK, REG_TEST_IN_MODE,         REG_TEST_IN_MODE_MASK,      BIT1|BIT0,      PINMUX_FOR_TEST_IN_MODE_3},
    {PAD_TTL1, CHIPTOP_BANK, REG_TEST_OUT_MODE,        REG_TEST_OUT_MODE_MASK,     BIT5|BIT4,      PINMUX_FOR_TEST_OUT_MODE_3},
    {PAD_TTL1, CHIPTOP_BANK, REG_I2C0_MODE,            REG_I2C0_MODE_MASK,         BIT1,           PINMUX_FOR_I2C0_MODE_2},
    {PAD_TTL1, CHIPTOP_BANK, REG_FUART_MODE,           REG_FUART_MODE_MASK,        BIT1|BIT0,      PINMUX_FOR_FUART_MODE_3},
    {PAD_TTL1, CHIPTOP_BANK, REG_ETH1_MODE,            REG_ETH1_MODE_MASK,         BIT10|BIT9|BIT8,PINMUX_FOR_ETH1_MODE_7},
    {PAD_TTL1, CHIPTOP_BANK, REG_DMIC_MODE,            REG_DMIC_MODE_MASK,         BIT8,           PINMUX_FOR_DMIC_MODE_1},
    {PAD_TTL1, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT8,           PINMUX_FOR_TTL_MODE_1},
    {PAD_TTL1, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT9|BIT8,      PINMUX_FOR_TTL_MODE_3},
    {PAD_TTL1, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT10,          PINMUX_FOR_TTL_MODE_4},
    {PAD_TTL1, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT10|BIT9|BIT8,PINMUX_FOR_TTL_MODE_7},
    {PAD_TTL1, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11,          PINMUX_FOR_TTL_MODE_8},
    {PAD_TTL1, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT8,     PINMUX_FOR_TTL_MODE_9},
    {PAD_TTL1, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT9,     PINMUX_FOR_TTL_MODE_10},
    {PAD_TTL1, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT9|BIT8,PINMUX_FOR_TTL_MODE_11},
    {PAD_TTL1, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT10,    PINMUX_FOR_TTL_MODE_12},
    {PAD_TTL1, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT10|BIT8,PINMUX_FOR_TTL_MODE_13},

    {PAD_TTL2, CHIPTOP_BANK, REG_I2C0_MODE,            REG_I2C0_MODE_MASK,         BIT1,           PINMUX_FOR_I2C0_MODE_2},
    {PAD_TTL2, CHIPTOP_BANK, REG_ETH1_MODE,            REG_ETH1_MODE_MASK,         BIT10|BIT9|BIT8,PINMUX_FOR_ETH1_MODE_7},
    {PAD_TTL2, CHIPTOP_BANK, REG_DMIC_MODE,            REG_DMIC_MODE_MASK,         BIT8,           PINMUX_FOR_DMIC_MODE_1},
    {PAD_TTL2, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT8,           PINMUX_FOR_TTL_MODE_1},
    {PAD_TTL2, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT9|BIT8,      PINMUX_FOR_TTL_MODE_3},
    {PAD_TTL2, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT10,          PINMUX_FOR_TTL_MODE_4},
    {PAD_TTL2, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT10|BIT9|BIT8,PINMUX_FOR_TTL_MODE_7},
    {PAD_TTL2, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11,          PINMUX_FOR_TTL_MODE_8},
    {PAD_TTL2, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT8,     PINMUX_FOR_TTL_MODE_9},
    {PAD_TTL2, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT9,     PINMUX_FOR_TTL_MODE_10},
    {PAD_TTL2, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT9|BIT8,PINMUX_FOR_TTL_MODE_11},
    {PAD_TTL2, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT10,    PINMUX_FOR_TTL_MODE_12},
    {PAD_TTL2, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT10|BIT8,PINMUX_FOR_TTL_MODE_13},

    {PAD_TTL3, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT8,           PINMUX_FOR_TTL_MODE_1},
    {PAD_TTL3, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT9,           PINMUX_FOR_TTL_MODE_2},
    {PAD_TTL3, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT9|BIT8,      PINMUX_FOR_TTL_MODE_3},
    {PAD_TTL3, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT10,          PINMUX_FOR_TTL_MODE_4},
    {PAD_TTL3, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT10|BIT9|BIT8,PINMUX_FOR_TTL_MODE_7},
    {PAD_TTL3, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11,          PINMUX_FOR_TTL_MODE_8},
    {PAD_TTL3, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT9,     PINMUX_FOR_TTL_MODE_10},
    {PAD_TTL3, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT9|BIT8,PINMUX_FOR_TTL_MODE_11},

    {PAD_TTL4, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT8,           PINMUX_FOR_TTL_MODE_1},
    {PAD_TTL4, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT9,           PINMUX_FOR_TTL_MODE_2},
    {PAD_TTL4, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT9|BIT8,      PINMUX_FOR_TTL_MODE_3},
    {PAD_TTL4, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT10,          PINMUX_FOR_TTL_MODE_4},
    {PAD_TTL4, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT10|BIT9|BIT8,PINMUX_FOR_TTL_MODE_7},
    {PAD_TTL4, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT8,     PINMUX_FOR_TTL_MODE_9},
    {PAD_TTL4, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT9,     PINMUX_FOR_TTL_MODE_10},
    {PAD_TTL4, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT9|BIT8,PINMUX_FOR_TTL_MODE_11},

    {PAD_TTL5, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT8,           PINMUX_FOR_TTL_MODE_1},
    {PAD_TTL5, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT9,           PINMUX_FOR_TTL_MODE_2},
    {PAD_TTL5, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT9|BIT8,      PINMUX_FOR_TTL_MODE_3},
    {PAD_TTL5, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT10,          PINMUX_FOR_TTL_MODE_4},
    {PAD_TTL5, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT10|BIT9|BIT8,PINMUX_FOR_TTL_MODE_7},
    {PAD_TTL5, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT8,     PINMUX_FOR_TTL_MODE_9},
    {PAD_TTL5, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT9,     PINMUX_FOR_TTL_MODE_10},
    {PAD_TTL5, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT9|BIT8,PINMUX_FOR_TTL_MODE_11},

    {PAD_TTL6, CHIPTOP_BANK, REG_TX_MIPI_MODE,         REG_TX_MIPI_MODE_MASK,      BIT12,          PINMUX_FOR_TX_MIPI_MODE_1},
    {PAD_TTL6, CHIPTOP_BANK, REG_TX_MIPI_MODE,         REG_TX_MIPI_MODE_MASK,      BIT13,          PINMUX_FOR_TX_MIPI_MODE_2},
    {PAD_TTL6, CHIPTOP_BANK, REG_TEST_IN_MODE,         REG_TEST_IN_MODE_MASK,      BIT0,           PINMUX_FOR_TEST_IN_MODE_1},
    {PAD_TTL6, CHIPTOP_BANK, REG_TEST_IN_MODE,         REG_TEST_IN_MODE_MASK,      BIT1|BIT0,      PINMUX_FOR_TEST_IN_MODE_3},
    {PAD_TTL6, CHIPTOP_BANK, REG_TEST_OUT_MODE,        REG_TEST_OUT_MODE_MASK,     BIT4,           PINMUX_FOR_TEST_OUT_MODE_1},
    {PAD_TTL6, CHIPTOP_BANK, REG_TEST_OUT_MODE,        REG_TEST_OUT_MODE_MASK,     BIT5|BIT4,      PINMUX_FOR_TEST_OUT_MODE_3},
    {PAD_TTL6, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT8,           PINMUX_FOR_TTL_MODE_1},
    {PAD_TTL6, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT9,           PINMUX_FOR_TTL_MODE_2},
    {PAD_TTL6, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT9|BIT8,      PINMUX_FOR_TTL_MODE_3},
    {PAD_TTL6, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT10,          PINMUX_FOR_TTL_MODE_4},
    {PAD_TTL6, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT10|BIT8,     PINMUX_FOR_TTL_MODE_5},
    {PAD_TTL6, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT10|BIT9,     PINMUX_FOR_TTL_MODE_6},
    {PAD_TTL6, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT10|BIT9|BIT8,PINMUX_FOR_TTL_MODE_7},
    {PAD_TTL6, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT8,     PINMUX_FOR_TTL_MODE_9},
    {PAD_TTL6, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT9,     PINMUX_FOR_TTL_MODE_10},
    {PAD_TTL6, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT9|BIT8,PINMUX_FOR_TTL_MODE_11},
    {PAD_TTL6, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT10,    PINMUX_FOR_TTL_MODE_12},
    {PAD_TTL6, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT10|BIT8,PINMUX_FOR_TTL_MODE_13},
    {PAD_TTL6, CHIPTOP_BANK, REG_BT1120_MODE,          REG_BT1120_MODE_MASK,       BIT0,           PINMUX_FOR_BT1120_MODE_1},
    {PAD_TTL6, CHIPTOP_BANK, REG_BT1120_MODE,          REG_BT1120_MODE_MASK,       BIT1,           PINMUX_FOR_BT1120_MODE_2},

    {PAD_TTL7, CHIPTOP_BANK, REG_TX_MIPI_MODE,         REG_TX_MIPI_MODE_MASK,      BIT12,          PINMUX_FOR_TX_MIPI_MODE_1},
    {PAD_TTL7, CHIPTOP_BANK, REG_TX_MIPI_MODE,         REG_TX_MIPI_MODE_MASK,      BIT13,          PINMUX_FOR_TX_MIPI_MODE_2},
    {PAD_TTL7, CHIPTOP_BANK, REG_TEST_IN_MODE,         REG_TEST_IN_MODE_MASK,      BIT0,           PINMUX_FOR_TEST_IN_MODE_1},
    {PAD_TTL7, CHIPTOP_BANK, REG_TEST_IN_MODE,         REG_TEST_IN_MODE_MASK,      BIT1|BIT0,      PINMUX_FOR_TEST_IN_MODE_3},
    {PAD_TTL7, CHIPTOP_BANK, REG_TEST_OUT_MODE,        REG_TEST_OUT_MODE_MASK,     BIT4,           PINMUX_FOR_TEST_OUT_MODE_1},
    {PAD_TTL7, CHIPTOP_BANK, REG_TEST_OUT_MODE,        REG_TEST_OUT_MODE_MASK,     BIT5|BIT4,      PINMUX_FOR_TEST_OUT_MODE_3},
    {PAD_TTL7, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT8,           PINMUX_FOR_TTL_MODE_1},
    {PAD_TTL7, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT9,           PINMUX_FOR_TTL_MODE_2},
    {PAD_TTL7, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT9|BIT8,      PINMUX_FOR_TTL_MODE_3},
    {PAD_TTL7, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT10,          PINMUX_FOR_TTL_MODE_4},
    {PAD_TTL7, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT10|BIT8,     PINMUX_FOR_TTL_MODE_5},
    {PAD_TTL7, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT10|BIT9,     PINMUX_FOR_TTL_MODE_6},
    {PAD_TTL7, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT10|BIT9|BIT8,PINMUX_FOR_TTL_MODE_7},
    {PAD_TTL7, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11,          PINMUX_FOR_TTL_MODE_8},
    {PAD_TTL7, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT8,     PINMUX_FOR_TTL_MODE_9},
    {PAD_TTL7, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT9,     PINMUX_FOR_TTL_MODE_10},
    {PAD_TTL7, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT9|BIT8,PINMUX_FOR_TTL_MODE_11},
    {PAD_TTL7, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT10,    PINMUX_FOR_TTL_MODE_12},
    {PAD_TTL7, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT10|BIT8,PINMUX_FOR_TTL_MODE_13},
    {PAD_TTL7, CHIPTOP_BANK, REG_BT1120_MODE,          REG_BT1120_MODE_MASK,       BIT0,           PINMUX_FOR_BT1120_MODE_1},
    {PAD_TTL7, CHIPTOP_BANK, REG_BT1120_MODE,          REG_BT1120_MODE_MASK,       BIT1,           PINMUX_FOR_BT1120_MODE_2},

    {PAD_TTL8, CHIPTOP_BANK, REG_TX_MIPI_MODE,         REG_TX_MIPI_MODE_MASK,      BIT12,          PINMUX_FOR_TX_MIPI_MODE_1},
    {PAD_TTL8, CHIPTOP_BANK, REG_TX_MIPI_MODE,         REG_TX_MIPI_MODE_MASK,      BIT13,          PINMUX_FOR_TX_MIPI_MODE_2},
    {PAD_TTL8, CHIPTOP_BANK, REG_TEST_IN_MODE,         REG_TEST_IN_MODE_MASK,      BIT0,           PINMUX_FOR_TEST_IN_MODE_1},
    {PAD_TTL8, CHIPTOP_BANK, REG_TEST_IN_MODE,         REG_TEST_IN_MODE_MASK,      BIT1|BIT0,      PINMUX_FOR_TEST_IN_MODE_3},
    {PAD_TTL8, CHIPTOP_BANK, REG_TEST_OUT_MODE,        REG_TEST_OUT_MODE_MASK,     BIT4,           PINMUX_FOR_TEST_OUT_MODE_1},
    {PAD_TTL8, CHIPTOP_BANK, REG_TEST_OUT_MODE,        REG_TEST_OUT_MODE_MASK,     BIT5|BIT4,      PINMUX_FOR_TEST_OUT_MODE_3},
    {PAD_TTL8, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT8,           PINMUX_FOR_TTL_MODE_1},
    {PAD_TTL8, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT9|BIT8,      PINMUX_FOR_TTL_MODE_3},
    {PAD_TTL8, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT10,          PINMUX_FOR_TTL_MODE_4},
    {PAD_TTL8, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT10|BIT8,     PINMUX_FOR_TTL_MODE_5},
    {PAD_TTL8, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT10|BIT9,     PINMUX_FOR_TTL_MODE_6},
    {PAD_TTL8, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT10|BIT9|BIT8,PINMUX_FOR_TTL_MODE_7},
    {PAD_TTL8, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11,          PINMUX_FOR_TTL_MODE_8},
    {PAD_TTL8, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT8,     PINMUX_FOR_TTL_MODE_9},
    {PAD_TTL8, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT9,     PINMUX_FOR_TTL_MODE_10},
    {PAD_TTL8, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT9|BIT8,PINMUX_FOR_TTL_MODE_11},
    {PAD_TTL8, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT10,    PINMUX_FOR_TTL_MODE_12},
    {PAD_TTL8, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT10|BIT8,PINMUX_FOR_TTL_MODE_13},
    {PAD_TTL8, CHIPTOP_BANK, REG_BT1120_MODE,          REG_BT1120_MODE_MASK,       BIT0,           PINMUX_FOR_BT1120_MODE_1},
    {PAD_TTL8, CHIPTOP_BANK, REG_BT1120_MODE,          REG_BT1120_MODE_MASK,       BIT1,           PINMUX_FOR_BT1120_MODE_2},

    {PAD_TTL9, CHIPTOP_BANK, REG_TX_MIPI_MODE,         REG_TX_MIPI_MODE_MASK,      BIT12,          PINMUX_FOR_TX_MIPI_MODE_1},
    {PAD_TTL9, CHIPTOP_BANK, REG_TX_MIPI_MODE,         REG_TX_MIPI_MODE_MASK,      BIT13,          PINMUX_FOR_TX_MIPI_MODE_2},
    {PAD_TTL9, CHIPTOP_BANK, REG_TEST_IN_MODE,         REG_TEST_IN_MODE_MASK,      BIT0,           PINMUX_FOR_TEST_IN_MODE_1},
    {PAD_TTL9, CHIPTOP_BANK, REG_TEST_IN_MODE,         REG_TEST_IN_MODE_MASK,      BIT1|BIT0,      PINMUX_FOR_TEST_IN_MODE_3},
    {PAD_TTL9, CHIPTOP_BANK, REG_TEST_OUT_MODE,        REG_TEST_OUT_MODE_MASK,     BIT4,           PINMUX_FOR_TEST_OUT_MODE_1},
    {PAD_TTL9, CHIPTOP_BANK, REG_TEST_OUT_MODE,        REG_TEST_OUT_MODE_MASK,     BIT5|BIT4,      PINMUX_FOR_TEST_OUT_MODE_3},
    {PAD_TTL9, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT8,           PINMUX_FOR_TTL_MODE_1},
    {PAD_TTL9, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT9|BIT8,      PINMUX_FOR_TTL_MODE_3},
    {PAD_TTL9, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT10,          PINMUX_FOR_TTL_MODE_4},
    {PAD_TTL9, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT10|BIT8,     PINMUX_FOR_TTL_MODE_5},
    {PAD_TTL9, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT10|BIT9,     PINMUX_FOR_TTL_MODE_6},
    {PAD_TTL9, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT10|BIT9|BIT8,PINMUX_FOR_TTL_MODE_7},
    {PAD_TTL9, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11,          PINMUX_FOR_TTL_MODE_8},
    {PAD_TTL9, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT8,     PINMUX_FOR_TTL_MODE_9},
    {PAD_TTL9, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT9,     PINMUX_FOR_TTL_MODE_10},
    {PAD_TTL9, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT9|BIT8,PINMUX_FOR_TTL_MODE_11},
    {PAD_TTL9, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT10,    PINMUX_FOR_TTL_MODE_12},
    {PAD_TTL9, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT10|BIT8,PINMUX_FOR_TTL_MODE_13},
    {PAD_TTL9, CHIPTOP_BANK, REG_BT1120_MODE,          REG_BT1120_MODE_MASK,       BIT0,           PINMUX_FOR_BT1120_MODE_1},
    {PAD_TTL9, CHIPTOP_BANK, REG_BT1120_MODE,          REG_BT1120_MODE_MASK,       BIT1,           PINMUX_FOR_BT1120_MODE_2},

    {PAD_TTL10, CHIPTOP_BANK, REG_TX_MIPI_MODE,         REG_TX_MIPI_MODE_MASK,      BIT12,          PINMUX_FOR_TX_MIPI_MODE_1},
    {PAD_TTL10, CHIPTOP_BANK, REG_TX_MIPI_MODE,         REG_TX_MIPI_MODE_MASK,      BIT13,          PINMUX_FOR_TX_MIPI_MODE_2},
    {PAD_TTL10, CHIPTOP_BANK, REG_TEST_IN_MODE,         REG_TEST_IN_MODE_MASK,      BIT0,           PINMUX_FOR_TEST_IN_MODE_1},
    {PAD_TTL10, CHIPTOP_BANK, REG_TEST_IN_MODE,         REG_TEST_IN_MODE_MASK,      BIT1|BIT0,      PINMUX_FOR_TEST_IN_MODE_3},
    {PAD_TTL10, CHIPTOP_BANK, REG_TEST_OUT_MODE,        REG_TEST_OUT_MODE_MASK,     BIT4,           PINMUX_FOR_TEST_OUT_MODE_1},
    {PAD_TTL10, CHIPTOP_BANK, REG_TEST_OUT_MODE,        REG_TEST_OUT_MODE_MASK,     BIT5|BIT4,      PINMUX_FOR_TEST_OUT_MODE_3},
    {PAD_TTL10, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT8,           PINMUX_FOR_TTL_MODE_1},
    {PAD_TTL10, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT9,           PINMUX_FOR_TTL_MODE_2},
    {PAD_TTL10, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT9|BIT8,      PINMUX_FOR_TTL_MODE_3},
    {PAD_TTL10, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT10,          PINMUX_FOR_TTL_MODE_4},
    {PAD_TTL10, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT10|BIT8,     PINMUX_FOR_TTL_MODE_5},
    {PAD_TTL10, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT10|BIT9,     PINMUX_FOR_TTL_MODE_6},
    {PAD_TTL10, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT10|BIT9|BIT8,PINMUX_FOR_TTL_MODE_7},
    {PAD_TTL10, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11,          PINMUX_FOR_TTL_MODE_8},
    {PAD_TTL10, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT8,     PINMUX_FOR_TTL_MODE_9},
    {PAD_TTL10, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT9,     PINMUX_FOR_TTL_MODE_10},
    {PAD_TTL10, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT9|BIT8,PINMUX_FOR_TTL_MODE_11},
    {PAD_TTL10, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT10,    PINMUX_FOR_TTL_MODE_12},
    {PAD_TTL10, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT10|BIT8,PINMUX_FOR_TTL_MODE_13},
    {PAD_TTL10, CHIPTOP_BANK, REG_BT1120_MODE,          REG_BT1120_MODE_MASK,       BIT0,           PINMUX_FOR_BT1120_MODE_1},
    {PAD_TTL10, CHIPTOP_BANK, REG_BT1120_MODE,          REG_BT1120_MODE_MASK,       BIT1,           PINMUX_FOR_BT1120_MODE_2},

    {PAD_TTL11, CHIPTOP_BANK, REG_TX_MIPI_MODE,         REG_TX_MIPI_MODE_MASK,      BIT12,          PINMUX_FOR_TX_MIPI_MODE_1},
    {PAD_TTL11, CHIPTOP_BANK, REG_TX_MIPI_MODE,         REG_TX_MIPI_MODE_MASK,      BIT13,          PINMUX_FOR_TX_MIPI_MODE_2},
    {PAD_TTL11, CHIPTOP_BANK, REG_TEST_IN_MODE,         REG_TEST_IN_MODE_MASK,      BIT0,           PINMUX_FOR_TEST_IN_MODE_1},
    {PAD_TTL11, CHIPTOP_BANK, REG_TEST_IN_MODE,         REG_TEST_IN_MODE_MASK,      BIT1|BIT0,      PINMUX_FOR_TEST_IN_MODE_3},
    {PAD_TTL11, CHIPTOP_BANK, REG_TEST_OUT_MODE,        REG_TEST_OUT_MODE_MASK,     BIT4,           PINMUX_FOR_TEST_OUT_MODE_1},
    {PAD_TTL11, CHIPTOP_BANK, REG_TEST_OUT_MODE,        REG_TEST_OUT_MODE_MASK,     BIT5|BIT4,      PINMUX_FOR_TEST_OUT_MODE_3},
    {PAD_TTL11, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT8,           PINMUX_FOR_TTL_MODE_1},
    {PAD_TTL11, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT9,           PINMUX_FOR_TTL_MODE_2},
    {PAD_TTL11, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT9|BIT8,      PINMUX_FOR_TTL_MODE_3},
    {PAD_TTL11, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT10,          PINMUX_FOR_TTL_MODE_4},
    {PAD_TTL11, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT10|BIT8,     PINMUX_FOR_TTL_MODE_5},
    {PAD_TTL11, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT10|BIT9,     PINMUX_FOR_TTL_MODE_6},
    {PAD_TTL11, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT10|BIT9|BIT8,PINMUX_FOR_TTL_MODE_7},
    {PAD_TTL11, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11,          PINMUX_FOR_TTL_MODE_8},
    {PAD_TTL11, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT8,     PINMUX_FOR_TTL_MODE_9},
    {PAD_TTL11, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT9,     PINMUX_FOR_TTL_MODE_10},
    {PAD_TTL11, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT9|BIT8,PINMUX_FOR_TTL_MODE_11},
    {PAD_TTL11, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT10,    PINMUX_FOR_TTL_MODE_12},
    {PAD_TTL11, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT10|BIT8,PINMUX_FOR_TTL_MODE_13},
    {PAD_TTL11, CHIPTOP_BANK, REG_BT1120_MODE,          REG_BT1120_MODE_MASK,       BIT0,           PINMUX_FOR_BT1120_MODE_1},
    {PAD_TTL11, CHIPTOP_BANK, REG_BT1120_MODE,          REG_BT1120_MODE_MASK,       BIT1,           PINMUX_FOR_BT1120_MODE_2},

    {PAD_TTL12, CHIPTOP_BANK, REG_EJ_MODE,              REG_EJ_MODE_MASK,           BIT1,           PINMUX_FOR_EJ_MODE_2},
    {PAD_TTL12, CHIPTOP_BANK, REG_TX_MIPI_MODE,         REG_TX_MIPI_MODE_MASK,      BIT12,          PINMUX_FOR_TX_MIPI_MODE_1},
    {PAD_TTL12, CHIPTOP_BANK, REG_TEST_IN_MODE,         REG_TEST_IN_MODE_MASK,      BIT0,           PINMUX_FOR_TEST_IN_MODE_1},
    {PAD_TTL12, CHIPTOP_BANK, REG_TEST_IN_MODE,         REG_TEST_IN_MODE_MASK,      BIT1|BIT0,      PINMUX_FOR_TEST_IN_MODE_3},
    {PAD_TTL12, CHIPTOP_BANK, REG_TEST_OUT_MODE,        REG_TEST_OUT_MODE_MASK,     BIT4,           PINMUX_FOR_TEST_OUT_MODE_1},
    {PAD_TTL12, CHIPTOP_BANK, REG_TEST_OUT_MODE,        REG_TEST_OUT_MODE_MASK,     BIT5|BIT4,      PINMUX_FOR_TEST_OUT_MODE_3},
    {PAD_TTL12, CHIPTOP_BANK, REG_UART0_MODE,           REG_UART0_MODE_MASK,        BIT5|BIT4,      PINMUX_FOR_UART0_MODE_3},
    {PAD_TTL12, CHIPTOP_BANK, REG_PWM1_MODE,            REG_PWM1_MODE_MASK,         BIT4,           PINMUX_FOR_PWM1_MODE_2},
    {PAD_TTL12, CHIPTOP_BANK, REG_I2S_MODE,             REG_I2S_MODE_MASK,          BIT13,          PINMUX_FOR_I2S_MODE_2},
    {PAD_TTL12, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT8,           PINMUX_FOR_TTL_MODE_1},
    {PAD_TTL12, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT9,           PINMUX_FOR_TTL_MODE_2},
    {PAD_TTL12, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT9|BIT8,      PINMUX_FOR_TTL_MODE_3},
    {PAD_TTL12, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT10,          PINMUX_FOR_TTL_MODE_4},
    {PAD_TTL12, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT10|BIT8,     PINMUX_FOR_TTL_MODE_5},
    {PAD_TTL12, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT10|BIT9,     PINMUX_FOR_TTL_MODE_6},
    {PAD_TTL12, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT10|BIT9|BIT8,PINMUX_FOR_TTL_MODE_7},
    {PAD_TTL12, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT8,     PINMUX_FOR_TTL_MODE_9},
    {PAD_TTL12, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT9,     PINMUX_FOR_TTL_MODE_10},
    {PAD_TTL12, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT9|BIT8,PINMUX_FOR_TTL_MODE_11},
    {PAD_TTL12, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT10,    PINMUX_FOR_TTL_MODE_12},
    {PAD_TTL12, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT10|BIT8,PINMUX_FOR_TTL_MODE_13},
    {PAD_TTL12, CHIPTOP_BANK, REG_BT1120_MODE,          REG_BT1120_MODE_MASK,       BIT0,           PINMUX_FOR_BT1120_MODE_1},
    {PAD_TTL12, CHIPTOP_BANK, REG_BT1120_MODE,          REG_BT1120_MODE_MASK,       BIT1,           PINMUX_FOR_BT1120_MODE_2},

    {PAD_TTL13, CHIPTOP_BANK, REG_EJ_MODE,              REG_EJ_MODE_MASK,           BIT1,           PINMUX_FOR_EJ_MODE_2},
    {PAD_TTL13, CHIPTOP_BANK, REG_TX_MIPI_MODE,         REG_TX_MIPI_MODE_MASK,      BIT12,          PINMUX_FOR_TX_MIPI_MODE_1},
    {PAD_TTL13, CHIPTOP_BANK, REG_TEST_IN_MODE,         REG_TEST_IN_MODE_MASK,      BIT0,           PINMUX_FOR_TEST_IN_MODE_1},
    {PAD_TTL13, CHIPTOP_BANK, REG_TEST_IN_MODE,         REG_TEST_IN_MODE_MASK,      BIT1|BIT0,      PINMUX_FOR_TEST_IN_MODE_3},
    {PAD_TTL13, CHIPTOP_BANK, REG_TEST_OUT_MODE,        REG_TEST_OUT_MODE_MASK,     BIT4,           PINMUX_FOR_TEST_OUT_MODE_1},
    {PAD_TTL13, CHIPTOP_BANK, REG_TEST_OUT_MODE,        REG_TEST_OUT_MODE_MASK,     BIT5|BIT4,      PINMUX_FOR_TEST_OUT_MODE_3},
    {PAD_TTL13, CHIPTOP_BANK, REG_UART0_MODE,           REG_UART0_MODE_MASK,        BIT5|BIT4,      PINMUX_FOR_UART0_MODE_3},
    {PAD_TTL13, CHIPTOP_BANK, REG_I2S_MODE,             REG_I2S_MODE_MASK,          BIT13,          PINMUX_FOR_I2S_MODE_2},
    {PAD_TTL13, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT8,           PINMUX_FOR_TTL_MODE_1},
    {PAD_TTL13, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT9,           PINMUX_FOR_TTL_MODE_2},
    {PAD_TTL13, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT9|BIT8,      PINMUX_FOR_TTL_MODE_3},
    {PAD_TTL13, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT10,          PINMUX_FOR_TTL_MODE_4},
    {PAD_TTL13, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT10|BIT8,     PINMUX_FOR_TTL_MODE_5},
    {PAD_TTL13, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT10|BIT9,     PINMUX_FOR_TTL_MODE_6},
    {PAD_TTL13, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT10|BIT9|BIT8,PINMUX_FOR_TTL_MODE_7},
    {PAD_TTL13, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT8,     PINMUX_FOR_TTL_MODE_9},
    {PAD_TTL13, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT9,     PINMUX_FOR_TTL_MODE_10},
    {PAD_TTL13, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT9|BIT8,PINMUX_FOR_TTL_MODE_11},
    {PAD_TTL13, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT10,    PINMUX_FOR_TTL_MODE_12},
    {PAD_TTL13, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT10|BIT8,PINMUX_FOR_TTL_MODE_13},
    {PAD_TTL13, CHIPTOP_BANK, REG_BT1120_MODE,          REG_BT1120_MODE_MASK,       BIT0,           PINMUX_FOR_BT1120_MODE_1},
    {PAD_TTL13, CHIPTOP_BANK, REG_BT1120_MODE,          REG_BT1120_MODE_MASK,       BIT1,           PINMUX_FOR_BT1120_MODE_2},

    {PAD_TTL14, CHIPTOP_BANK, REG_EJ_MODE,              REG_EJ_MODE_MASK,           BIT1,           PINMUX_FOR_EJ_MODE_2},
    {PAD_TTL14, CHIPTOP_BANK, REG_TX_MIPI_MODE,         REG_TX_MIPI_MODE_MASK,      BIT12,          PINMUX_FOR_TX_MIPI_MODE_1},
    {PAD_TTL14, CHIPTOP_BANK, REG_TEST_IN_MODE,         REG_TEST_IN_MODE_MASK,      BIT0,           PINMUX_FOR_TEST_IN_MODE_1},
    {PAD_TTL14, CHIPTOP_BANK, REG_TEST_OUT_MODE,        REG_TEST_OUT_MODE_MASK,     BIT4,           PINMUX_FOR_TEST_OUT_MODE_1},
    {PAD_TTL14, CHIPTOP_BANK, REG_I2C0_MODE,            REG_I2C0_MODE_MASK,         BIT1|BIT0,      PINMUX_FOR_I2C0_MODE_3},
    {PAD_TTL14, CHIPTOP_BANK, REG_UART1_MODE,           REG_UART1_MODE_MASK,        BIT9,           PINMUX_FOR_UART1_MODE_2},
    {PAD_TTL14, CHIPTOP_BANK, REG_I2S_MODE,             REG_I2S_MODE_MASK,          BIT13,          PINMUX_FOR_I2S_MODE_2},
    {PAD_TTL14, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT8,           PINMUX_FOR_TTL_MODE_1},
    {PAD_TTL14, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT9,           PINMUX_FOR_TTL_MODE_2},
    {PAD_TTL14, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT9|BIT8,      PINMUX_FOR_TTL_MODE_3},
    {PAD_TTL14, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT10,          PINMUX_FOR_TTL_MODE_4},
    {PAD_TTL14, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT10|BIT8,     PINMUX_FOR_TTL_MODE_5},
    {PAD_TTL14, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT10|BIT9,     PINMUX_FOR_TTL_MODE_6},
    {PAD_TTL14, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT10|BIT9|BIT8,PINMUX_FOR_TTL_MODE_7},
    {PAD_TTL14, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11,          PINMUX_FOR_TTL_MODE_8},
    {PAD_TTL14, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT8,     PINMUX_FOR_TTL_MODE_9},
    {PAD_TTL14, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT9,     PINMUX_FOR_TTL_MODE_10},
    {PAD_TTL14, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT9|BIT8,PINMUX_FOR_TTL_MODE_11},
    {PAD_TTL14, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT10,    PINMUX_FOR_TTL_MODE_12},
    {PAD_TTL14, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT10|BIT8,PINMUX_FOR_TTL_MODE_13},
    {PAD_TTL14, CHIPTOP_BANK, REG_BT1120_MODE,          REG_BT1120_MODE_MASK,       BIT0,           PINMUX_FOR_BT1120_MODE_1},

    {PAD_TTL15, CHIPTOP_BANK, REG_EJ_MODE,              REG_EJ_MODE_MASK,           BIT1,           PINMUX_FOR_EJ_MODE_2},
    {PAD_TTL15, CHIPTOP_BANK, REG_TX_MIPI_MODE,         REG_TX_MIPI_MODE_MASK,      BIT12,          PINMUX_FOR_TX_MIPI_MODE_1},
    {PAD_TTL15, CHIPTOP_BANK, REG_TEST_IN_MODE,         REG_TEST_IN_MODE_MASK,      BIT0,           PINMUX_FOR_TEST_IN_MODE_1},
    {PAD_TTL15, CHIPTOP_BANK, REG_TEST_OUT_MODE,        REG_TEST_OUT_MODE_MASK,     BIT4,           PINMUX_FOR_TEST_OUT_MODE_1},
    {PAD_TTL15, CHIPTOP_BANK, REG_I2C0_MODE,            REG_I2C0_MODE_MASK,         BIT1|BIT0,      PINMUX_FOR_I2C0_MODE_3},
    {PAD_TTL15, CHIPTOP_BANK, REG_UART1_MODE,           REG_UART1_MODE_MASK,        BIT9,           PINMUX_FOR_UART1_MODE_2},
    {PAD_TTL15, CHIPTOP_BANK, REG_I2S_MODE,             REG_I2S_MODE_MASK,          BIT13,          PINMUX_FOR_I2S_MODE_2},
    {PAD_TTL15, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT8,           PINMUX_FOR_TTL_MODE_1},
    {PAD_TTL15, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT9,           PINMUX_FOR_TTL_MODE_2},
    {PAD_TTL15, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT9|BIT8,      PINMUX_FOR_TTL_MODE_3},
    {PAD_TTL15, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT10,          PINMUX_FOR_TTL_MODE_4},
    {PAD_TTL15, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT10|BIT8,     PINMUX_FOR_TTL_MODE_5},
    {PAD_TTL15, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT10|BIT9,     PINMUX_FOR_TTL_MODE_6},
    {PAD_TTL15, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT10|BIT9|BIT8,PINMUX_FOR_TTL_MODE_7},
    {PAD_TTL15, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11,          PINMUX_FOR_TTL_MODE_8},
    {PAD_TTL15, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT8,     PINMUX_FOR_TTL_MODE_9},
    {PAD_TTL15, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT9,     PINMUX_FOR_TTL_MODE_10},
    {PAD_TTL15, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT9|BIT8,PINMUX_FOR_TTL_MODE_11},
    {PAD_TTL15, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT10,    PINMUX_FOR_TTL_MODE_12},
    {PAD_TTL15, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT10|BIT8,PINMUX_FOR_TTL_MODE_13},
    {PAD_TTL15, CHIPTOP_BANK, REG_BT1120_MODE,          REG_BT1120_MODE_MASK,       BIT0,           PINMUX_FOR_BT1120_MODE_1},

    {PAD_TTL16, CHIPTOP_BANK, REG_TEST_IN_MODE,         REG_TEST_IN_MODE_MASK,      BIT0,           PINMUX_FOR_TEST_IN_MODE_1},
    {PAD_TTL16, CHIPTOP_BANK, REG_TEST_OUT_MODE,        REG_TEST_OUT_MODE_MASK,     BIT4,           PINMUX_FOR_TEST_OUT_MODE_1},
    {PAD_TTL16, CHIPTOP_BANK, REG_SPI0_MODE,            REG_SPI0_MODE_MASK,         BIT1,           PINMUX_FOR_SPI0_MODE_2},
    {PAD_TTL16, CHIPTOP_BANK, REG_FUART_MODE,           REG_FUART_MODE_MASK,        BIT2|BIT1,      PINMUX_FOR_FUART_MODE_6},
    {PAD_TTL16, CHIPTOP_BANK, REG_ETH0_MODE,            REG_ETH0_MODE_MASK,         BIT0,           PINMUX_FOR_ETH0_MODE},
    {PAD_TTL16, CHIPTOP_BANK, REG_ETH1_MODE,            REG_ETH1_MODE_MASK,         BIT8,           PINMUX_FOR_ETH1_MODE_1},
    {PAD_TTL16, CHIPTOP_BANK, REG_ETH1_MODE,            REG_ETH1_MODE_MASK,         BIT9,           PINMUX_FOR_ETH1_MODE_2},
    {PAD_TTL16, CHIPTOP_BANK, REG_ETH1_MODE,            REG_ETH1_MODE_MASK,         BIT9|BIT8,      PINMUX_FOR_ETH1_MODE_3},
    {PAD_TTL16, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT8,           PINMUX_FOR_TTL_MODE_1},
    {PAD_TTL16, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT10,          PINMUX_FOR_TTL_MODE_4},
    {PAD_TTL16, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT10|BIT8,     PINMUX_FOR_TTL_MODE_5},
    {PAD_TTL16, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT10|BIT9,     PINMUX_FOR_TTL_MODE_6},
    {PAD_TTL16, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT10|BIT9|BIT8,PINMUX_FOR_TTL_MODE_7},
    {PAD_TTL16, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11,          PINMUX_FOR_TTL_MODE_8},
    {PAD_TTL16, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT8,     PINMUX_FOR_TTL_MODE_9},
    {PAD_TTL16, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT9,     PINMUX_FOR_TTL_MODE_10},
    {PAD_TTL16, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT9|BIT8,PINMUX_FOR_TTL_MODE_11},
    {PAD_TTL16, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT10,    PINMUX_FOR_TTL_MODE_12},
    {PAD_TTL16, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT10|BIT8,PINMUX_FOR_TTL_MODE_13},
    {PAD_TTL16, CHIPTOP_BANK, REG_BT1120_MODE,          REG_BT1120_MODE_MASK,       BIT0,           PINMUX_FOR_BT1120_MODE_1},

    {PAD_TTL17, CHIPTOP_BANK, REG_TEST_IN_MODE,         REG_TEST_IN_MODE_MASK,      BIT0,           PINMUX_FOR_TEST_IN_MODE_1},
    {PAD_TTL17, CHIPTOP_BANK, REG_TEST_OUT_MODE,        REG_TEST_OUT_MODE_MASK,     BIT4,           PINMUX_FOR_TEST_OUT_MODE_1},
    {PAD_TTL17, CHIPTOP_BANK, REG_SPI0_MODE,            REG_SPI0_MODE_MASK,         BIT1,           PINMUX_FOR_SPI0_MODE_2},
    {PAD_TTL17, CHIPTOP_BANK, REG_ETH0_MODE,            REG_ETH0_MODE_MASK,         BIT0,           PINMUX_FOR_ETH0_MODE},
    {PAD_TTL17, CHIPTOP_BANK, REG_ETH1_MODE,            REG_ETH1_MODE_MASK,         BIT8,           PINMUX_FOR_ETH1_MODE_1},
    {PAD_TTL17, CHIPTOP_BANK, REG_ETH1_MODE,            REG_ETH1_MODE_MASK,         BIT9,           PINMUX_FOR_ETH1_MODE_2},
    {PAD_TTL17, CHIPTOP_BANK, REG_ETH1_MODE,            REG_ETH1_MODE_MASK,         BIT9|BIT8,      PINMUX_FOR_ETH1_MODE_3},
    {PAD_TTL17, CHIPTOP_BANK, REG_ETH1_MODE,            REG_ETH1_MODE_MASK,         BIT10,          PINMUX_FOR_ETH1_MODE_4},
    {PAD_TTL17, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT8,           PINMUX_FOR_TTL_MODE_1},
    {PAD_TTL17, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT10,          PINMUX_FOR_TTL_MODE_4},
    {PAD_TTL17, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT10|BIT8,     PINMUX_FOR_TTL_MODE_5},
    {PAD_TTL17, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT10|BIT9,     PINMUX_FOR_TTL_MODE_6},
    {PAD_TTL17, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT10|BIT9|BIT8,PINMUX_FOR_TTL_MODE_7},
    {PAD_TTL17, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11,          PINMUX_FOR_TTL_MODE_8},
    {PAD_TTL17, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT8,     PINMUX_FOR_TTL_MODE_9},
    {PAD_TTL17, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT9,     PINMUX_FOR_TTL_MODE_10},
    {PAD_TTL17, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT9|BIT8,PINMUX_FOR_TTL_MODE_11},
    {PAD_TTL17, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT10,    PINMUX_FOR_TTL_MODE_12},
    {PAD_TTL17, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT10|BIT8,PINMUX_FOR_TTL_MODE_13},
    {PAD_TTL17, CHIPTOP_BANK, REG_BT1120_MODE,          REG_BT1120_MODE_MASK,       BIT0,           PINMUX_FOR_BT1120_MODE_1},

    {PAD_TTL18, CHIPTOP_BANK, REG_TEST_IN_MODE,         REG_TEST_IN_MODE_MASK,      BIT0,           PINMUX_FOR_TEST_IN_MODE_1},
    {PAD_TTL18, CHIPTOP_BANK, REG_TEST_OUT_MODE,        REG_TEST_OUT_MODE_MASK,     BIT4,           PINMUX_FOR_TEST_OUT_MODE_1},
    {PAD_TTL18, CHIPTOP_BANK, REG_SPI0_MODE,            REG_SPI0_MODE_MASK,         BIT1,           PINMUX_FOR_SPI0_MODE_2},
    {PAD_TTL18, CHIPTOP_BANK, REG_ETH0_MODE,            REG_ETH0_MODE_MASK,         BIT0,           PINMUX_FOR_ETH0_MODE},
    {PAD_TTL18, CHIPTOP_BANK, REG_ETH1_MODE,            REG_ETH1_MODE_MASK,         BIT8,           PINMUX_FOR_ETH1_MODE_1},
    {PAD_TTL18, CHIPTOP_BANK, REG_ETH1_MODE,            REG_ETH1_MODE_MASK,         BIT9,           PINMUX_FOR_ETH1_MODE_2},
    {PAD_TTL18, CHIPTOP_BANK, REG_ETH1_MODE,            REG_ETH1_MODE_MASK,         BIT9|BIT8,      PINMUX_FOR_ETH1_MODE_3},
    {PAD_TTL18, CHIPTOP_BANK, REG_ETH1_MODE,            REG_ETH1_MODE_MASK,         BIT10,          PINMUX_FOR_ETH1_MODE_4},
    {PAD_TTL18, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT8,           PINMUX_FOR_TTL_MODE_1},
    {PAD_TTL18, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT10|BIT8,     PINMUX_FOR_TTL_MODE_5},
    {PAD_TTL18, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT10|BIT9,     PINMUX_FOR_TTL_MODE_6},
    {PAD_TTL18, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT10|BIT9|BIT8,PINMUX_FOR_TTL_MODE_7},
    {PAD_TTL18, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11,          PINMUX_FOR_TTL_MODE_8},
    {PAD_TTL18, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT8,     PINMUX_FOR_TTL_MODE_9},
    {PAD_TTL18, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT9,     PINMUX_FOR_TTL_MODE_10},
    {PAD_TTL18, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT9|BIT8,PINMUX_FOR_TTL_MODE_11},
    {PAD_TTL18, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT10,    PINMUX_FOR_TTL_MODE_12},
    {PAD_TTL18, CHIPTOP_BANK, REG_BT1120_MODE,          REG_BT1120_MODE_MASK,       BIT0,           PINMUX_FOR_BT1120_MODE_1},

    {PAD_TTL19, CHIPTOP_BANK, REG_TEST_IN_MODE,         REG_TEST_IN_MODE_MASK,      BIT0,           PINMUX_FOR_TEST_IN_MODE_1},
    {PAD_TTL19, CHIPTOP_BANK, REG_TEST_OUT_MODE,        REG_TEST_OUT_MODE_MASK,     BIT4,           PINMUX_FOR_TEST_OUT_MODE_1},
    {PAD_TTL19, CHIPTOP_BANK, REG_SPI0_MODE,            REG_SPI0_MODE_MASK,         BIT1,           PINMUX_FOR_SPI0_MODE_2},
    {PAD_TTL19, CHIPTOP_BANK, REG_ETH0_MODE,            REG_ETH0_MODE_MASK,         BIT0,           PINMUX_FOR_ETH0_MODE},
    {PAD_TTL19, CHIPTOP_BANK, REG_ETH1_MODE,            REG_ETH1_MODE_MASK,         BIT8,           PINMUX_FOR_ETH1_MODE_1},
    {PAD_TTL19, CHIPTOP_BANK, REG_ETH1_MODE,            REG_ETH1_MODE_MASK,         BIT9,           PINMUX_FOR_ETH1_MODE_2},
    {PAD_TTL19, CHIPTOP_BANK, REG_ETH1_MODE,            REG_ETH1_MODE_MASK,         BIT9|BIT8,      PINMUX_FOR_ETH1_MODE_3},
    {PAD_TTL19, CHIPTOP_BANK, REG_ETH1_MODE,            REG_ETH1_MODE_MASK,         BIT10,          PINMUX_FOR_ETH1_MODE_4},
    {PAD_TTL19, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT8,           PINMUX_FOR_TTL_MODE_1},
    {PAD_TTL19, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT9,           PINMUX_FOR_TTL_MODE_2},
    {PAD_TTL19, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT10|BIT8,     PINMUX_FOR_TTL_MODE_5},
    {PAD_TTL19, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT10|BIT9,     PINMUX_FOR_TTL_MODE_6},
    {PAD_TTL19, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT10|BIT9|BIT8,PINMUX_FOR_TTL_MODE_7},
    {PAD_TTL19, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11,          PINMUX_FOR_TTL_MODE_8},
    {PAD_TTL19, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT8,     PINMUX_FOR_TTL_MODE_9},
    {PAD_TTL19, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT9,     PINMUX_FOR_TTL_MODE_10},
    {PAD_TTL19, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT9|BIT8,PINMUX_FOR_TTL_MODE_11},
    {PAD_TTL19, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT10,    PINMUX_FOR_TTL_MODE_12},
    {PAD_TTL19, CHIPTOP_BANK, REG_BT1120_MODE,          REG_BT1120_MODE_MASK,       BIT0,           PINMUX_FOR_BT1120_MODE_1},

    {PAD_TTL20, CHIPTOP_BANK, REG_TEST_IN_MODE,         REG_TEST_IN_MODE_MASK,      BIT0,           PINMUX_FOR_TEST_IN_MODE_1},
    {PAD_TTL20, CHIPTOP_BANK, REG_TEST_OUT_MODE,        REG_TEST_OUT_MODE_MASK,     BIT4,           PINMUX_FOR_TEST_OUT_MODE_1},
    {PAD_TTL20, CHIPTOP_BANK, REG_FUART_MODE,           REG_FUART_MODE_MASK,        BIT2,           PINMUX_FOR_FUART_MODE_4},
    {PAD_TTL20, CHIPTOP_BANK, REG_PWM3_MODE,            REG_PWM3_MODE_MASK,         BIT11,          PINMUX_FOR_PWM3_MODE_4},
    {PAD_TTL20, CHIPTOP_BANK, REG_ETH0_MODE,            REG_ETH0_MODE_MASK,         BIT0,           PINMUX_FOR_ETH0_MODE},
    {PAD_TTL20, CHIPTOP_BANK, REG_ETH1_MODE,            REG_ETH1_MODE_MASK,         BIT8,           PINMUX_FOR_ETH1_MODE_1},
    {PAD_TTL20, CHIPTOP_BANK, REG_ETH1_MODE,            REG_ETH1_MODE_MASK,         BIT9,           PINMUX_FOR_ETH1_MODE_2},
    {PAD_TTL20, CHIPTOP_BANK, REG_ETH1_MODE,            REG_ETH1_MODE_MASK,         BIT9|BIT8,      PINMUX_FOR_ETH1_MODE_3},
    {PAD_TTL20, CHIPTOP_BANK, REG_ETH1_MODE,            REG_ETH1_MODE_MASK,         BIT10,          PINMUX_FOR_ETH1_MODE_4},
    {PAD_TTL20, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT8,           PINMUX_FOR_TTL_MODE_1},
    {PAD_TTL20, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT9,           PINMUX_FOR_TTL_MODE_2},
    {PAD_TTL20, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT10|BIT8,     PINMUX_FOR_TTL_MODE_5},
    {PAD_TTL20, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT10|BIT9,     PINMUX_FOR_TTL_MODE_6},
    {PAD_TTL20, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT10|BIT9|BIT8,PINMUX_FOR_TTL_MODE_7},
    {PAD_TTL20, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT8,     PINMUX_FOR_TTL_MODE_9},
    {PAD_TTL20, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT9|BIT8,PINMUX_FOR_TTL_MODE_11},
    {PAD_TTL20, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT10,    PINMUX_FOR_TTL_MODE_12},
    {PAD_TTL20, CHIPTOP_BANK, REG_BT1120_MODE,          REG_BT1120_MODE_MASK,       BIT0,           PINMUX_FOR_BT1120_MODE_1},

    {PAD_TTL21, CHIPTOP_BANK, REG_TEST_IN_MODE,         REG_TEST_IN_MODE_MASK,      BIT0,           PINMUX_FOR_TEST_IN_MODE_1},
    {PAD_TTL21, CHIPTOP_BANK, REG_TEST_OUT_MODE,        REG_TEST_OUT_MODE_MASK,     BIT4,           PINMUX_FOR_TEST_OUT_MODE_1},
    {PAD_TTL21, CHIPTOP_BANK, REG_FUART_MODE,           REG_FUART_MODE_MASK,        BIT2,           PINMUX_FOR_FUART_MODE_4},
    {PAD_TTL21, CHIPTOP_BANK, REG_PWM2_MODE,            REG_PWM2_MODE_MASK,         BIT8,           PINMUX_FOR_PWM2_MODE_4},
    {PAD_TTL21, CHIPTOP_BANK, REG_ETH0_MODE,            REG_ETH0_MODE_MASK,         BIT0,           PINMUX_FOR_ETH0_MODE},
    {PAD_TTL21, CHIPTOP_BANK, REG_ETH1_MODE,            REG_ETH1_MODE_MASK,         BIT8,           PINMUX_FOR_ETH1_MODE_1},
    {PAD_TTL21, CHIPTOP_BANK, REG_ETH1_MODE,            REG_ETH1_MODE_MASK,         BIT9,           PINMUX_FOR_ETH1_MODE_2},
    {PAD_TTL21, CHIPTOP_BANK, REG_ETH1_MODE,            REG_ETH1_MODE_MASK,         BIT9|BIT8,      PINMUX_FOR_ETH1_MODE_3},
    {PAD_TTL21, CHIPTOP_BANK, REG_ETH1_MODE,            REG_ETH1_MODE_MASK,         BIT10,          PINMUX_FOR_ETH1_MODE_4},
    {PAD_TTL21, CHIPTOP_BANK, REG_ETH1_MODE,            REG_ETH1_MODE_MASK,         BIT10|BIT8,     PINMUX_FOR_ETH1_MODE_5},
    {PAD_TTL21, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT8,           PINMUX_FOR_TTL_MODE_1},
    {PAD_TTL21, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT9,           PINMUX_FOR_TTL_MODE_2},
    {PAD_TTL21, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT10|BIT8,     PINMUX_FOR_TTL_MODE_5},
    {PAD_TTL21, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT10|BIT9,     PINMUX_FOR_TTL_MODE_6},
    {PAD_TTL21, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT10|BIT9|BIT8,PINMUX_FOR_TTL_MODE_7},
    {PAD_TTL21, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT8,     PINMUX_FOR_TTL_MODE_9},
    {PAD_TTL21, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT9|BIT8,PINMUX_FOR_TTL_MODE_11},
    {PAD_TTL21, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT10,    PINMUX_FOR_TTL_MODE_12},
    {PAD_TTL21, CHIPTOP_BANK, REG_BT1120_MODE,          REG_BT1120_MODE_MASK,       BIT0,           PINMUX_FOR_BT1120_MODE_1},

    {PAD_TTL22, CHIPTOP_BANK, REG_TEST_IN_MODE,         REG_TEST_IN_MODE_MASK,      BIT0,           PINMUX_FOR_TEST_IN_MODE_1},
    {PAD_TTL22, CHIPTOP_BANK, REG_TEST_IN_MODE,         REG_TEST_IN_MODE_MASK,      BIT1|BIT0,      PINMUX_FOR_TEST_IN_MODE_3},
    {PAD_TTL22, CHIPTOP_BANK, REG_TEST_OUT_MODE,        REG_TEST_OUT_MODE_MASK,     BIT4,           PINMUX_FOR_TEST_OUT_MODE_1},
    {PAD_TTL22, CHIPTOP_BANK, REG_TEST_OUT_MODE,        REG_TEST_OUT_MODE_MASK,     BIT5|BIT4,      PINMUX_FOR_TEST_OUT_MODE_3},
    {PAD_TTL22, CHIPTOP_BANK, REG_I2C1_MODE,            REG_I2C1_MODE_MASK,         BIT6,           PINMUX_FOR_I2C1_MODE_4},
    {PAD_TTL22, CHIPTOP_BANK, REG_PWM1_MODE,            REG_PWM1_MODE_MASK,         BIT4|BIT3,      PINMUX_FOR_PWM1_MODE_3},
    {PAD_TTL22, CHIPTOP_BANK, REG_ETH0_MODE,            REG_ETH0_MODE_MASK,         BIT0,           PINMUX_FOR_ETH0_MODE},
    {PAD_TTL22, CHIPTOP_BANK, REG_ETH1_MODE,            REG_ETH1_MODE_MASK,         BIT8,           PINMUX_FOR_ETH1_MODE_1},
    {PAD_TTL22, CHIPTOP_BANK, REG_ETH1_MODE,            REG_ETH1_MODE_MASK,         BIT9,           PINMUX_FOR_ETH1_MODE_2},
    {PAD_TTL22, CHIPTOP_BANK, REG_ETH1_MODE,            REG_ETH1_MODE_MASK,         BIT9|BIT8,      PINMUX_FOR_ETH1_MODE_3},
    {PAD_TTL22, CHIPTOP_BANK, REG_ETH1_MODE,            REG_ETH1_MODE_MASK,         BIT10,          PINMUX_FOR_ETH1_MODE_4},
    {PAD_TTL22, CHIPTOP_BANK, REG_ETH1_MODE,            REG_ETH1_MODE_MASK,         BIT10|BIT8,     PINMUX_FOR_ETH1_MODE_5},
    {PAD_TTL22, CHIPTOP_BANK, REG_ETH1_MODE,            REG_ETH1_MODE_MASK,         BIT10|BIT9,     PINMUX_FOR_ETH1_MODE_6},
    {PAD_TTL22, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT8,           PINMUX_FOR_TTL_MODE_1},
    {PAD_TTL22, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT9,           PINMUX_FOR_TTL_MODE_2},
    {PAD_TTL22, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT10|BIT9|BIT8,PINMUX_FOR_TTL_MODE_7},
    {PAD_TTL22, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT8,     PINMUX_FOR_TTL_MODE_9},
    {PAD_TTL22, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT10,    PINMUX_FOR_TTL_MODE_12},

    {PAD_TTL23, CHIPTOP_BANK, REG_TEST_IN_MODE,         REG_TEST_IN_MODE_MASK,      BIT0,           PINMUX_FOR_TEST_IN_MODE_1},
    {PAD_TTL23, CHIPTOP_BANK, REG_TEST_IN_MODE,         REG_TEST_IN_MODE_MASK,      BIT1|BIT0,      PINMUX_FOR_TEST_IN_MODE_3},
    {PAD_TTL23, CHIPTOP_BANK, REG_TEST_OUT_MODE,        REG_TEST_OUT_MODE_MASK,     BIT4,           PINMUX_FOR_TEST_OUT_MODE_1},
    {PAD_TTL23, CHIPTOP_BANK, REG_TEST_OUT_MODE,        REG_TEST_OUT_MODE_MASK,     BIT5|BIT4,      PINMUX_FOR_TEST_OUT_MODE_3},
    {PAD_TTL23, CHIPTOP_BANK, REG_I2C1_MODE,            REG_I2C1_MODE_MASK,         BIT6,           PINMUX_FOR_I2C1_MODE_4},
    {PAD_TTL23, CHIPTOP_BANK, REG_PWM0_MODE,            REG_PWM0_MODE_MASK,         BIT1,           PINMUX_FOR_PWM0_MODE_2},
    {PAD_TTL23, CHIPTOP_BANK, REG_ETH0_MODE,            REG_ETH0_MODE_MASK,         BIT0,           PINMUX_FOR_ETH0_MODE},
    {PAD_TTL23, CHIPTOP_BANK, REG_ETH1_MODE,            REG_ETH1_MODE_MASK,         BIT8,           PINMUX_FOR_ETH1_MODE_1},
    {PAD_TTL23, CHIPTOP_BANK, REG_ETH1_MODE,            REG_ETH1_MODE_MASK,         BIT9,           PINMUX_FOR_ETH1_MODE_2},
    {PAD_TTL23, CHIPTOP_BANK, REG_ETH1_MODE,            REG_ETH1_MODE_MASK,         BIT9|BIT8,      PINMUX_FOR_ETH1_MODE_3},
    {PAD_TTL23, CHIPTOP_BANK, REG_ETH1_MODE,            REG_ETH1_MODE_MASK,         BIT10,          PINMUX_FOR_ETH1_MODE_4},
    {PAD_TTL23, CHIPTOP_BANK, REG_ETH1_MODE,            REG_ETH1_MODE_MASK,         BIT10|BIT8,     PINMUX_FOR_ETH1_MODE_5},
    {PAD_TTL23, CHIPTOP_BANK, REG_ETH1_MODE,            REG_ETH1_MODE_MASK,         BIT10|BIT9,     PINMUX_FOR_ETH1_MODE_6},
    {PAD_TTL23, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT8,           PINMUX_FOR_TTL_MODE_1},
    {PAD_TTL23, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT9,           PINMUX_FOR_TTL_MODE_2},
    {PAD_TTL23, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT10|BIT9|BIT8,PINMUX_FOR_TTL_MODE_7},
    {PAD_TTL23, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11,          PINMUX_FOR_TTL_MODE_8},
    {PAD_TTL23, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT8,     PINMUX_FOR_TTL_MODE_9},
    {PAD_TTL23, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT10,    PINMUX_FOR_TTL_MODE_12},

    {PAD_TTL24, CHIPTOP_BANK, REG_TEST_IN_MODE,         REG_TEST_IN_MODE_MASK,      BIT0,           PINMUX_FOR_TEST_IN_MODE_1},
    {PAD_TTL24, CHIPTOP_BANK, REG_TEST_IN_MODE,         REG_TEST_IN_MODE_MASK,      BIT1|BIT0,      PINMUX_FOR_TEST_IN_MODE_3},
    {PAD_TTL24, CHIPTOP_BANK, REG_TEST_OUT_MODE,        REG_TEST_OUT_MODE_MASK,     BIT4,           PINMUX_FOR_TEST_OUT_MODE_1},
    {PAD_TTL24, CHIPTOP_BANK, REG_TEST_OUT_MODE,        REG_TEST_OUT_MODE_MASK,     BIT5|BIT4,      PINMUX_FOR_TEST_OUT_MODE_3},
    {PAD_TTL24, CHIPTOP_BANK, REG_ETH0_MODE,            REG_ETH0_MODE_MASK,         BIT0,           PINMUX_FOR_ETH0_MODE},
    {PAD_TTL24, CHIPTOP_BANK, REG_ETH1_MODE,            REG_ETH1_MODE_MASK,         BIT8,           PINMUX_FOR_ETH1_MODE_1},
    {PAD_TTL24, CHIPTOP_BANK, REG_ETH1_MODE,            REG_ETH1_MODE_MASK,         BIT9,           PINMUX_FOR_ETH1_MODE_2},
    {PAD_TTL24, CHIPTOP_BANK, REG_ETH1_MODE,            REG_ETH1_MODE_MASK,         BIT9|BIT8,      PINMUX_FOR_ETH1_MODE_3},
    {PAD_TTL24, CHIPTOP_BANK, REG_ETH1_MODE,            REG_ETH1_MODE_MASK,         BIT10|BIT8,     PINMUX_FOR_ETH1_MODE_5},
    {PAD_TTL24, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT8,           PINMUX_FOR_TTL_MODE_1},
    {PAD_TTL24, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT9,           PINMUX_FOR_TTL_MODE_2},
    {PAD_TTL24, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT9|BIT8,      PINMUX_FOR_TTL_MODE_3},
    {PAD_TTL24, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT10,          PINMUX_FOR_TTL_MODE_4},
    {PAD_TTL24, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT10|BIT8,     PINMUX_FOR_TTL_MODE_5},
    {PAD_TTL24, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT10|BIT9|BIT8,PINMUX_FOR_TTL_MODE_7},
    {PAD_TTL24, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11,          PINMUX_FOR_TTL_MODE_8},
    {PAD_TTL24, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT8,     PINMUX_FOR_TTL_MODE_9},
    {PAD_TTL24, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT10,    PINMUX_FOR_TTL_MODE_12},

    {PAD_TTL25, CHIPTOP_BANK, REG_TEST_IN_MODE,         REG_TEST_IN_MODE_MASK,      BIT0,           PINMUX_FOR_TEST_IN_MODE_1},
    {PAD_TTL25, CHIPTOP_BANK, REG_TEST_IN_MODE,         REG_TEST_IN_MODE_MASK,      BIT1|BIT0,      PINMUX_FOR_TEST_IN_MODE_3},
    {PAD_TTL25, CHIPTOP_BANK, REG_TEST_OUT_MODE,        REG_TEST_OUT_MODE_MASK,     BIT4,           PINMUX_FOR_TEST_OUT_MODE_1},
    {PAD_TTL25, CHIPTOP_BANK, REG_TEST_OUT_MODE,        REG_TEST_OUT_MODE_MASK,     BIT5|BIT4,      PINMUX_FOR_TEST_OUT_MODE_3},
    {PAD_TTL25, CHIPTOP_BANK, REG_ETH1_MODE,            REG_ETH1_MODE_MASK,         BIT10|BIT8,     PINMUX_FOR_ETH1_MODE_5},
    {PAD_TTL25, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT8,           PINMUX_FOR_TTL_MODE_1},
    {PAD_TTL25, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT9,           PINMUX_FOR_TTL_MODE_2},
    {PAD_TTL25, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT9|BIT8,      PINMUX_FOR_TTL_MODE_3},
    {PAD_TTL25, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT10,          PINMUX_FOR_TTL_MODE_4},
    {PAD_TTL25, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT10|BIT8,     PINMUX_FOR_TTL_MODE_5},
    {PAD_TTL25, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT10|BIT9|BIT8,PINMUX_FOR_TTL_MODE_7},
    {PAD_TTL25, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11,          PINMUX_FOR_TTL_MODE_8},
    {PAD_TTL25, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT8,     PINMUX_FOR_TTL_MODE_9},
    {PAD_TTL25, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT10,    PINMUX_FOR_TTL_MODE_12},
    {PAD_TTL25, CHIPTOP_BANK, REG_BT1120_MODE,          REG_BT1120_MODE_MASK,       BIT0,           PINMUX_FOR_BT1120_MODE_1},
    {PAD_TTL25, CHIPTOP_BANK, REG_BT1120_MODE,          REG_BT1120_MODE_MASK,       BIT1,           PINMUX_FOR_BT1120_MODE_2},

    {PAD_TTL26, CHIPTOP_BANK, REG_ETH1_MODE,            REG_ETH1_MODE_MASK,         BIT10|BIT8,     PINMUX_FOR_ETH1_MODE_5},
    {PAD_TTL26, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT8,           PINMUX_FOR_TTL_MODE_1},
    {PAD_TTL26, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT9,           PINMUX_FOR_TTL_MODE_2},
    {PAD_TTL26, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT9|BIT8,      PINMUX_FOR_TTL_MODE_3},
    {PAD_TTL26, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT10,          PINMUX_FOR_TTL_MODE_4},
    {PAD_TTL26, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT10|BIT8,     PINMUX_FOR_TTL_MODE_5},
    {PAD_TTL26, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT10|BIT9|BIT8,PINMUX_FOR_TTL_MODE_7},
    {PAD_TTL26, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11,          PINMUX_FOR_TTL_MODE_8},
    {PAD_TTL26, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT8,     PINMUX_FOR_TTL_MODE_9},

    {PAD_TTL27, CHIPTOP_BANK, REG_ETH1_MODE,            REG_ETH1_MODE_MASK,         BIT10|BIT8,     PINMUX_FOR_ETH1_MODE_5},
    {PAD_TTL27, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT8,           PINMUX_FOR_TTL_MODE_1},
    {PAD_TTL27, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT9,           PINMUX_FOR_TTL_MODE_2},
    {PAD_TTL27, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT9|BIT8,      PINMUX_FOR_TTL_MODE_3},
    {PAD_TTL27, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT10,          PINMUX_FOR_TTL_MODE_4},
    {PAD_TTL27, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT10|BIT8,     PINMUX_FOR_TTL_MODE_5},
    {PAD_TTL27, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT10|BIT9|BIT8,PINMUX_FOR_TTL_MODE_7},
    {PAD_TTL27, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11,          PINMUX_FOR_TTL_MODE_8},
    {PAD_TTL27, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT8,     PINMUX_FOR_TTL_MODE_9},

    {PAD_UART0_RX, CHIPTOP_BANK, REG_TEST_IN_MODE,         REG_TEST_IN_MODE_MASK,      BIT1|BIT0,      PINMUX_FOR_TEST_IN_MODE_3},
    {PAD_UART0_RX, CHIPTOP_BANK, REG_TEST_OUT_MODE,        REG_TEST_OUT_MODE_MASK,     BIT5|BIT4,      PINMUX_FOR_TEST_OUT_MODE_3},
    {PAD_UART0_RX, CHIPTOP_BANK, REG_UART0_MODE,           REG_UART0_MODE_MASK,        BIT4,           PINMUX_FOR_UART0_MODE_1},
    {PAD_UART0_RX, CHIPTOP_BANK, REG_ETH1_MODE,            REG_ETH1_MODE_MASK,         BIT11|BIT8,     PINMUX_FOR_ETH1_MODE_9},

    {PAD_UART0_TX, CHIPTOP_BANK, REG_TEST_IN_MODE,         REG_TEST_IN_MODE_MASK,      BIT1|BIT0,      PINMUX_FOR_TEST_IN_MODE_3},
    {PAD_UART0_TX, CHIPTOP_BANK, REG_TEST_OUT_MODE,        REG_TEST_OUT_MODE_MASK,     BIT5|BIT4,      PINMUX_FOR_TEST_OUT_MODE_3},
    {PAD_UART0_TX, CHIPTOP_BANK, REG_UART0_MODE,           REG_UART0_MODE_MASK,        BIT4,           PINMUX_FOR_UART0_MODE_1},
    {PAD_UART0_TX, CHIPTOP_BANK, REG_ETH1_MODE,            REG_ETH1_MODE_MASK,         BIT11|BIT8,     PINMUX_FOR_ETH1_MODE_9},

    {PAD_UART1_RX, CHIPTOP_BANK, REG_TEST_IN_MODE,         REG_TEST_IN_MODE_MASK,      BIT1|BIT0,      PINMUX_FOR_TEST_IN_MODE_3},
    {PAD_UART1_RX, CHIPTOP_BANK, REG_TEST_OUT_MODE,        REG_TEST_OUT_MODE_MASK,     BIT5|BIT4,      PINMUX_FOR_TEST_OUT_MODE_3},
    {PAD_UART1_RX, CHIPTOP_BANK, REG_UART1_MODE,           REG_UART1_MODE_MASK,        BIT8,           PINMUX_FOR_UART1_MODE_1},
    {PAD_UART1_RX, CHIPTOP_BANK, REG_DMIC_MODE,            REG_DMIC_MODE_MASK,         BIT10,          PINMUX_FOR_DMIC_MODE_4},

    {PAD_UART1_TX, CHIPTOP_BANK, REG_TEST_IN_MODE,         REG_TEST_IN_MODE_MASK,      BIT1|BIT0,      PINMUX_FOR_TEST_IN_MODE_3},
    {PAD_UART1_TX, CHIPTOP_BANK, REG_TEST_OUT_MODE,        REG_TEST_OUT_MODE_MASK,     BIT5|BIT4,      PINMUX_FOR_TEST_OUT_MODE_3},
    {PAD_UART1_TX, CHIPTOP_BANK, REG_UART1_MODE,           REG_UART1_MODE_MASK,        BIT8,           PINMUX_FOR_UART1_MODE_1},
    {PAD_UART1_TX, CHIPTOP_BANK, REG_DMIC_MODE,            REG_DMIC_MODE_MASK,         BIT10,          PINMUX_FOR_DMIC_MODE_4},
    {PAD_UART1_TX, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT10,    PINMUX_FOR_TTL_MODE_12},
    {PAD_UART1_TX, CHIPTOP_BANK, REG_TTL_MODE,             REG_TTL_MODE_MASK,          BIT11|BIT10|BIT8,PINMUX_FOR_TTL_MODE_13},

    {PAD_SD_CLK, CHIPTOP_BANK, REG_I2C1_MODE,            REG_I2C1_MODE_MASK,         BIT6|BIT4,      PINMUX_FOR_I2C1_MODE_5},
    {PAD_SD_CLK, CHIPTOP_BANK, REG_SPI0_MODE,            REG_SPI0_MODE_MASK,         BIT0,           PINMUX_FOR_SPI0_MODE_1},
    {PAD_SD_CLK, CHIPTOP_BANK, REG_SDIO_MODE,            REG_SDIO_MODE_MASK,         BIT8,           PINMUX_FOR_SDIO_MODE_1},
    {PAD_SD_CLK, CHIPTOP_BANK, REG_I2S_MODE,             REG_I2S_MODE_MASK,          BIT13|BIT12,    PINMUX_FOR_I2S_MODE_3},

    {PAD_SD_CMD, CHIPTOP_BANK, REG_TEST_IN_MODE,         REG_TEST_IN_MODE_MASK,      BIT1,           PINMUX_FOR_TEST_IN_MODE_2},
    {PAD_SD_CMD, CHIPTOP_BANK, REG_TEST_OUT_MODE,        REG_TEST_OUT_MODE_MASK,     BIT5,           PINMUX_FOR_TEST_OUT_MODE_2},
    {PAD_SD_CMD, CHIPTOP_BANK, REG_I2C1_MODE,            REG_I2C1_MODE_MASK,         BIT6|BIT4,      PINMUX_FOR_I2C1_MODE_5},
    {PAD_SD_CMD, CHIPTOP_BANK, REG_SPI0_MODE,            REG_SPI0_MODE_MASK,         BIT0,           PINMUX_FOR_SPI0_MODE_1},
    {PAD_SD_CMD, CHIPTOP_BANK, REG_SDIO_MODE,            REG_SDIO_MODE_MASK,         BIT8,           PINMUX_FOR_SDIO_MODE_1},
    {PAD_SD_CMD, CHIPTOP_BANK, REG_I2S_MODE,             REG_I2S_MODE_MASK,          BIT13|BIT12,    PINMUX_FOR_I2S_MODE_3},

    {PAD_SD_D0, CHIPTOP_BANK, REG_TEST_IN_MODE,         REG_TEST_IN_MODE_MASK,      BIT1,           PINMUX_FOR_TEST_IN_MODE_2},
    {PAD_SD_D0, CHIPTOP_BANK, REG_TEST_OUT_MODE,        REG_TEST_OUT_MODE_MASK,     BIT5,           PINMUX_FOR_TEST_OUT_MODE_2},
    {PAD_SD_D0, CHIPTOP_BANK, REG_SPI0_MODE,            REG_SPI0_MODE_MASK,         BIT0,           PINMUX_FOR_SPI0_MODE_1},
    {PAD_SD_D0, CHIPTOP_BANK, REG_FUART_MODE,           REG_FUART_MODE_MASK,        BIT2|BIT1|BIT0, PINMUX_FOR_FUART_MODE_7},
    {PAD_SD_D0, CHIPTOP_BANK, REG_SDIO_MODE,            REG_SDIO_MODE_MASK,         BIT8,           PINMUX_FOR_SDIO_MODE_1},
    {PAD_SD_D0, CHIPTOP_BANK, REG_I2S_MODE,             REG_I2S_MODE_MASK,          BIT13|BIT12,    PINMUX_FOR_I2S_MODE_3},

    {PAD_SD_D1, CHIPTOP_BANK, REG_TEST_IN_MODE,         REG_TEST_IN_MODE_MASK,      BIT1,           PINMUX_FOR_TEST_IN_MODE_2},
    {PAD_SD_D1, CHIPTOP_BANK, REG_TEST_OUT_MODE,        REG_TEST_OUT_MODE_MASK,     BIT5,           PINMUX_FOR_TEST_OUT_MODE_2},
    {PAD_SD_D1, CHIPTOP_BANK, REG_SPI0_MODE,            REG_SPI0_MODE_MASK,         BIT0,           PINMUX_FOR_SPI0_MODE_1},
    {PAD_SD_D1, CHIPTOP_BANK, REG_FUART_MODE,           REG_FUART_MODE_MASK,        BIT2|BIT1|BIT0, PINMUX_FOR_FUART_MODE_7},
    {PAD_SD_D1, CHIPTOP_BANK, REG_SDIO_MODE,            REG_SDIO_MODE_MASK,         BIT8,           PINMUX_FOR_SDIO_MODE_1},
    {PAD_SD_D1, CHIPTOP_BANK, REG_PWM2_MODE,            REG_PWM2_MODE_MASK,         BIT8|BIT7,      PINMUX_FOR_PWM2_MODE_6},

    {PAD_SD_D2, CHIPTOP_BANK, REG_TEST_IN_MODE,         REG_TEST_IN_MODE_MASK,      BIT1,           PINMUX_FOR_TEST_IN_MODE_2},
    {PAD_SD_D2, CHIPTOP_BANK, REG_TEST_OUT_MODE,        REG_TEST_OUT_MODE_MASK,     BIT5,           PINMUX_FOR_TEST_OUT_MODE_2},
    {PAD_SD_D2, CHIPTOP_BANK, REG_UART2_MODE,           REG_UART2_MODE_MASK,        BIT14,          PINMUX_FOR_UART2_MODE_4},
    {PAD_SD_D2, CHIPTOP_BANK, REG_SDIO_MODE,            REG_SDIO_MODE_MASK,         BIT8,           PINMUX_FOR_SDIO_MODE_1},

    {PAD_SD_D3, CHIPTOP_BANK, REG_TEST_IN_MODE,         REG_TEST_IN_MODE_MASK,      BIT1,           PINMUX_FOR_TEST_IN_MODE_2},
    {PAD_SD_D3, CHIPTOP_BANK, REG_TEST_OUT_MODE,        REG_TEST_OUT_MODE_MASK,     BIT5,           PINMUX_FOR_TEST_OUT_MODE_2},
    {PAD_SD_D3, CHIPTOP_BANK, REG_UART2_MODE,           REG_UART2_MODE_MASK,        BIT14,          PINMUX_FOR_UART2_MODE_4},
    {PAD_SD_D3, CHIPTOP_BANK, REG_SDIO_MODE,            REG_SDIO_MODE_MASK,         BIT8,           PINMUX_FOR_SDIO_MODE_1},
    {PAD_SD_D3, CHIPTOP_BANK, REG_I2S_MODE,             REG_I2S_MODE_MASK,          BIT13|BIT12,    PINMUX_FOR_I2S_MODE_3},


    {PAD_PM_SD_CDZ, CHIPTOP_BANK, REG_TEST_IN_MODE,         REG_TEST_IN_MODE_MASK,      BIT1,           PINMUX_FOR_TEST_IN_MODE_2},
    {PAD_PM_SD_CDZ, CHIPTOP_BANK, REG_TEST_OUT_MODE,        REG_TEST_OUT_MODE_MASK,     BIT5,           PINMUX_FOR_TEST_OUT_MODE_2},
    {PAD_PM_SD_CDZ, PMSLEEP_BANK, REG_PM_PWM3_MODE,         REG_PM_PWM3_MODE_MASK,      BIT8,           PINMUX_FOR_PM_PWM3_MODE},
    {PAD_PM_SD_CDZ, PMSLEEP_BANK, REG_PM_VID_MODE,          REG_PM_VID_MODE_MASK,       BIT13,          PINMUX_FOR_PM_VID_MODE_2},
    {PAD_PM_SD_CDZ, PMSLEEP_BANK, REG_PM_SD_CDZ_MODE,       REG_PM_SD_CDZ_MODE_MASK,    BIT14,          PINMUX_FOR_PM_SD_CDZ_MODE},

    {PAD_PM_IRIN, CHIPTOP_BANK, REG_TEST_IN_MODE,         REG_TEST_IN_MODE_MASK,      BIT1,           PINMUX_FOR_TEST_IN_MODE_2},
    {PAD_PM_IRIN, CHIPTOP_BANK, REG_TEST_OUT_MODE,        REG_TEST_OUT_MODE_MASK,     BIT5,           PINMUX_FOR_TEST_OUT_MODE_2},
    {PAD_PM_IRIN, PMSLEEP_BANK, REG_PM_SPICSZ2_GPIO,      REG_PM_SPICSZ2_GPIO_MASK,   0,              PINMUX_FOR_PM_SPICSZ2_MODE},
    {PAD_PM_IRIN, PMSLEEP_BANK, REG_PM_PWM2_MODE,         REG_PM_PWM2_MODE_MASK,      BIT6,           PINMUX_FOR_PM_PWM2_MODE},
    {PAD_PM_IRIN, PMSLEEP_BANK, REG_PM_IR_IS_GPIO,        REG_PM_IR_IS_GPIO_MASK,     0,              PINMUX_FOR_PM_IRIN_MODE},




    {PAD_PM_SPI_CZ, CHIPTOP_BANK, REG_TEST_IN_MODE,         REG_TEST_IN_MODE_MASK,      BIT1,           PINMUX_FOR_TEST_IN_MODE_2},
    {PAD_PM_SPI_CZ, CHIPTOP_BANK, REG_TEST_OUT_MODE,        REG_TEST_OUT_MODE_MASK,     BIT5,           PINMUX_FOR_TEST_OUT_MODE_2},
    {PAD_PM_SPI_CZ, PMSLEEP_BANK, REG_PM_SPICSZ1_GPIO,      REG_PM_SPICSZ1_GPIO_MASK,   0,              PINMUX_FOR_PM_SPICSZ1_MODE},

    {PAD_PM_SPI_CK, CHIPTOP_BANK, REG_TEST_IN_MODE,         REG_TEST_IN_MODE_MASK,      BIT1,           PINMUX_FOR_TEST_IN_MODE_2},
    {PAD_PM_SPI_CK, CHIPTOP_BANK, REG_TEST_OUT_MODE,        REG_TEST_OUT_MODE_MASK,     BIT5,           PINMUX_FOR_TEST_OUT_MODE_2},
    {PAD_PM_SPI_CK, PMSLEEP_BANK, REG_PM_SPI_GPIO,          REG_PM_SPI_GPIO_MASK,       0,              PINMUX_FOR_PM_SPI_MODE},

    {PAD_PM_SPI_DI, CHIPTOP_BANK, REG_TEST_IN_MODE,         REG_TEST_IN_MODE_MASK,      BIT1,           PINMUX_FOR_TEST_IN_MODE_2},
    {PAD_PM_SPI_DI, CHIPTOP_BANK, REG_TEST_OUT_MODE,        REG_TEST_OUT_MODE_MASK,     BIT5,           PINMUX_FOR_TEST_OUT_MODE_2},
    {PAD_PM_SPI_DI, PMSLEEP_BANK, REG_PM_SPI_GPIO,          REG_PM_SPI_GPIO_MASK,       0,              PINMUX_FOR_PM_SPI_MODE},

    {PAD_PM_SPI_DO, CHIPTOP_BANK, REG_TEST_IN_MODE,         REG_TEST_IN_MODE_MASK,      BIT1,           PINMUX_FOR_TEST_IN_MODE_2},
    {PAD_PM_SPI_DO, CHIPTOP_BANK, REG_TEST_OUT_MODE,        REG_TEST_OUT_MODE_MASK,     BIT5,           PINMUX_FOR_TEST_OUT_MODE_2},
    {PAD_PM_SPI_DO, PMSLEEP_BANK, REG_PM_SPI_GPIO,          REG_PM_SPI_GPIO_MASK,       0,              PINMUX_FOR_PM_SPI_MODE},

    {PAD_PM_SPI_WPZ, CHIPTOP_BANK, REG_TEST_IN_MODE,         REG_TEST_IN_MODE_MASK,      BIT1,           PINMUX_FOR_TEST_IN_MODE_2},
    {PAD_PM_SPI_WPZ, CHIPTOP_BANK, REG_TEST_OUT_MODE,        REG_TEST_OUT_MODE_MASK,     BIT5,           PINMUX_FOR_TEST_OUT_MODE_2},
    {PAD_PM_SPI_WPZ, PMSLEEP_BANK, REG_PM_SPIWPN_GPIO,       REG_PM_SPIWPN_GPIO_MASK,    0,              PINMUX_FOR_PM_SPIWPN_MODE},

    {PAD_PM_SPI_HLD, PMSLEEP_BANK, REG_PM_SPIHOLDN_MODE,     REG_PM_SPIHOLDN_MODE_MASK,  0,              PINMUX_FOR_PM_SPIHOLDN_MODE},

    {PAD_PM_LED0, PMSLEEP_BANK, REG_PM_PWM0_MODE,         REG_PM_PWM0_MODE_MASK,      BIT0,           PINMUX_FOR_PM_PWM0_MODE},
    {PAD_PM_LED0, PMSLEEP_BANK, REG_PM_UART1_MODE,        REG_PM_UART1_MODE_MASK,     BIT8,           PINMUX_FOR_PM_UART1_MODE},
    {PAD_PM_LED0, PMSLEEP_BANK, REG_PM_VID_MODE,          REG_PM_VID_MODE_MASK,       BIT12,          PINMUX_FOR_PM_VID_MODE_1},
    {PAD_PM_LED0, PMSLEEP_BANK, REG_PM_VID_MODE,          REG_PM_VID_MODE_MASK,       BIT13|BIT12,    PINMUX_FOR_PM_VID_MODE_3},
    {PAD_PM_LED0, PMSLEEP_BANK, REG_PM_LED_MODE,          REG_PM_LED_MODE_MASK,       BIT4,           PINMUX_FOR_PM_LED_MODE_1},
    {PAD_PM_LED0, PMSLEEP_BANK, REG_PM_LED_MODE,          REG_PM_LED_MODE_MASK,       BIT5,           PINMUX_FOR_PM_LED_MODE_2},
    {PAD_PM_LED0, PMSLEEP_BANK, REG_PM_LED_MODE,          REG_PM_LED_MODE_MASK,       BIT5|BIT4,      PINMUX_FOR_PM_LED_MODE_3},

    {PAD_PM_LED1, PMSLEEP_BANK, REG_PM_PWM1_MODE,         REG_PM_PWM1_MODE_MASK,      BIT2,           PINMUX_FOR_PM_PWM1_MODE},
    {PAD_PM_LED1, PMSLEEP_BANK, REG_PM_UART1_MODE,        REG_PM_UART1_MODE_MASK,     BIT8,           PINMUX_FOR_PM_UART1_MODE},
    {PAD_PM_LED1, PMSLEEP_BANK, REG_PM_VID_MODE,          REG_PM_VID_MODE_MASK,       BIT12,          PINMUX_FOR_PM_VID_MODE_1},
    {PAD_PM_LED1, PMSLEEP_BANK, REG_PM_LED_MODE,          REG_PM_LED_MODE_MASK,       BIT4,           PINMUX_FOR_PM_LED_MODE_1},
/*
    {PAD_SAR_GPIO0, CHIPTOP_BANK, REG_TEST_IN_MODE,         REG_TEST_IN_MODE_MASK,      BIT1,           PINMUX_FOR_TEST_IN_MODE_2},
    {PAD_SAR_GPIO0, CHIPTOP_BANK, REG_TEST_OUT_MODE,        REG_TEST_OUT_MODE_MASK,     BIT5,           PINMUX_FOR_TEST_OUT_MODE_2},
    {PAD_SAR_GPIO0, PMSLEEP_BANK, REG_PM_SPICSZ2_MODE,      REG_PM_SPICSZ2_MODE_MASK,   BIT12,          PINMUX_FOR_PM_SPICSZ2_MODE},

    {PAD_SAR_GPIO1, CHIPTOP_BANK, REG_TEST_IN_MODE,         REG_TEST_IN_MODE_MASK,      BIT1,           PINMUX_FOR_TEST_IN_MODE_2},
    {PAD_SAR_GPIO1, CHIPTOP_BANK, REG_TEST_OUT_MODE,        REG_TEST_OUT_MODE_MASK,     BIT5,           PINMUX_FOR_TEST_OUT_MODE_2},



    {PAD_ETH_RN, CHIPTOP_BANK, REG_TEST_IN_MODE,         REG_TEST_IN_MODE_MASK,      BIT1,           PINMUX_FOR_TEST_IN_MODE_2},
    {PAD_ETH_RN, CHIPTOP_BANK, REG_TEST_OUT_MODE,        REG_TEST_OUT_MODE_MASK,     BIT5,           PINMUX_FOR_TEST_OUT_MODE_2},
*/

    {PAD_HSYNC_OUT, CHIPTOP_BANK, REG_TEST_IN_MODE,         REG_TEST_IN_MODE_MASK,      BIT1,           PINMUX_FOR_TEST_IN_MODE_2},
    {PAD_HSYNC_OUT, CHIPTOP_BANK, REG_TEST_IN_MODE,         REG_TEST_IN_MODE_MASK,      BIT1|BIT0,      PINMUX_FOR_TEST_IN_MODE_3},
    {PAD_HSYNC_OUT, CHIPTOP_BANK, REG_TEST_OUT_MODE,        REG_TEST_OUT_MODE_MASK,     BIT5,           PINMUX_FOR_TEST_OUT_MODE_2},
    {PAD_HSYNC_OUT, CHIPTOP_BANK, REG_TEST_OUT_MODE,        REG_TEST_OUT_MODE_MASK,     BIT5|BIT4,      PINMUX_FOR_TEST_OUT_MODE_3},
    {PAD_HSYNC_OUT, CHIPTOP_BANK, REG_UART2_MODE,           REG_UART2_MODE_MASK,        BIT13|BIT12,    PINMUX_FOR_UART2_MODE_3},
    {PAD_HSYNC_OUT, CHIPTOP_BANK, REG_IDAC_MODE,            REG_IDAC_MODE_MASK,         BIT0,           PINMUX_FOR_IDAC_MODE},

    {PAD_VSYNC_OUT, CHIPTOP_BANK, REG_TEST_IN_MODE,         REG_TEST_IN_MODE_MASK,      BIT1,           PINMUX_FOR_TEST_IN_MODE_2},
    {PAD_VSYNC_OUT, CHIPTOP_BANK, REG_TEST_IN_MODE,         REG_TEST_IN_MODE_MASK,      BIT1|BIT0,      PINMUX_FOR_TEST_IN_MODE_3},
    {PAD_VSYNC_OUT, CHIPTOP_BANK, REG_TEST_OUT_MODE,        REG_TEST_OUT_MODE_MASK,     BIT5,           PINMUX_FOR_TEST_OUT_MODE_2},
    {PAD_VSYNC_OUT, CHIPTOP_BANK, REG_TEST_OUT_MODE,        REG_TEST_OUT_MODE_MASK,     BIT5|BIT4,      PINMUX_FOR_TEST_OUT_MODE_3},
    {PAD_VSYNC_OUT, CHIPTOP_BANK, REG_UART2_MODE,           REG_UART2_MODE_MASK,        BIT13|BIT12,    PINMUX_FOR_UART2_MODE_3},
    {PAD_VSYNC_OUT, CHIPTOP_BANK, REG_IDAC_MODE,            REG_IDAC_MODE_MASK,         BIT0,           PINMUX_FOR_IDAC_MODE},

    {PAD_HDMITX_SCL, CHIPTOP_BANK, REG_TEST_IN_MODE,         REG_TEST_IN_MODE_MASK,      BIT1,           PINMUX_FOR_TEST_IN_MODE_2},
    {PAD_HDMITX_SCL, CHIPTOP_BANK, REG_TEST_IN_MODE,         REG_TEST_IN_MODE_MASK,      BIT1|BIT0,      PINMUX_FOR_TEST_IN_MODE_3},
    {PAD_HDMITX_SCL, CHIPTOP_BANK, REG_TEST_OUT_MODE,        REG_TEST_OUT_MODE_MASK,     BIT5,           PINMUX_FOR_TEST_OUT_MODE_2},
    {PAD_HDMITX_SCL, CHIPTOP_BANK, REG_TEST_OUT_MODE,        REG_TEST_OUT_MODE_MASK,     BIT5|BIT4,      PINMUX_FOR_TEST_OUT_MODE_3},
    {PAD_HDMITX_SCL, CHIPTOP_BANK, REG_I2C0_MODE,            REG_I2C0_MODE_MASK,         BIT0,           PINMUX_FOR_I2C0_MODE_1},
    {PAD_HDMITX_SCL, CHIPTOP_BANK, REG_I2C1_MODE,            REG_I2C1_MODE_MASK,         BIT5,           PINMUX_FOR_I2C1_MODE_2},
    {PAD_HDMITX_SCL, CHIPTOP_BANK, REG_DMIC_MODE,            REG_DMIC_MODE_MASK,         BIT9,           PINMUX_FOR_DMIC_MODE_2},

    {PAD_HDMITX_SDA, CHIPTOP_BANK, REG_TEST_IN_MODE,         REG_TEST_IN_MODE_MASK,      BIT1,           PINMUX_FOR_TEST_IN_MODE_2},
    {PAD_HDMITX_SDA, CHIPTOP_BANK, REG_TEST_IN_MODE,         REG_TEST_IN_MODE_MASK,      BIT1|BIT0,      PINMUX_FOR_TEST_IN_MODE_3},
    {PAD_HDMITX_SDA, CHIPTOP_BANK, REG_TEST_OUT_MODE,        REG_TEST_OUT_MODE_MASK,     BIT5,           PINMUX_FOR_TEST_OUT_MODE_2},
    {PAD_HDMITX_SDA, CHIPTOP_BANK, REG_TEST_OUT_MODE,        REG_TEST_OUT_MODE_MASK,     BIT5|BIT4,      PINMUX_FOR_TEST_OUT_MODE_3},
    {PAD_HDMITX_SDA, CHIPTOP_BANK, REG_I2C0_MODE,            REG_I2C0_MODE_MASK,         BIT0,           PINMUX_FOR_I2C0_MODE_1},
    {PAD_HDMITX_SDA, CHIPTOP_BANK, REG_I2C1_MODE,            REG_I2C1_MODE_MASK,         BIT5,           PINMUX_FOR_I2C1_MODE_2},
    {PAD_HDMITX_SDA, CHIPTOP_BANK, REG_DMIC_MODE,            REG_DMIC_MODE_MASK,         BIT9,           PINMUX_FOR_DMIC_MODE_2},

    {PAD_HDMITX_HPD, CHIPTOP_BANK, REG_TEST_IN_MODE,         REG_TEST_IN_MODE_MASK,      BIT1,           PINMUX_FOR_TEST_IN_MODE_2},
    {PAD_HDMITX_HPD, CHIPTOP_BANK, REG_TEST_OUT_MODE,        REG_TEST_OUT_MODE_MASK,     BIT5,           PINMUX_FOR_TEST_OUT_MODE_2},
    {PAD_HDMITX_HPD, CHIPTOP_BANK, REG_PWM2_MODE,            REG_PWM2_MODE_MASK,         BIT7|BIT6,      PINMUX_FOR_PWM2_MODE_3},
    {PAD_HDMITX_HPD, CHIPTOP_BANK, REG_DMIC_MODE,            REG_DMIC_MODE_MASK,         BIT9,           PINMUX_FOR_DMIC_MODE_2},

    {PAD_SATA_GPIO, CHIPTOP_BANK, REG_TEST_IN_MODE,         REG_TEST_IN_MODE_MASK,      BIT1,           PINMUX_FOR_TEST_IN_MODE_2},
    {PAD_SATA_GPIO, CHIPTOP_BANK, REG_TEST_OUT_MODE,        REG_TEST_OUT_MODE_MASK,     BIT5,           PINMUX_FOR_TEST_OUT_MODE_2},
    {PAD_SATA_GPIO, CHIPTOP_BANK, REG_PWM1_MODE,            REG_PWM1_MODE_MASK,         BIT5|BIT3,      PINMUX_FOR_PWM1_MODE_5},
    {PAD_SATA_GPIO, CHIPTOP_BANK, REG_SATA_LED_MODE,        REG_SATA_LED_MODE_MASK,     BIT0,           PINMUX_FOR_SATA_LED_MODE},

};

U32 g_u32Padmux_cnt = sizeof(m_stPadMuxTbl)/sizeof(ST_PadMuxInfo);


//==============================================================================
//
//                              padmode_info
//
//==============================================================================
#define BASE_RIU_PA                         0xFD000000
#define GET_BASE_ADDR_BY_BANK(x, y)         ((x) + ((y) << 1))
#define _RIUA_16BIT(bank , offset)          GET_BASE_ADDR_BY_BANK(BASE_RIU_PA, bank) + ((offset)<<2)

const ST_PadModeInfo m_stPadModeInfoTbl[] =
{
    {"GPIO",    0,                                              0},
    // Non PM
    {"EJ_MODE_1",       _RIUA_16BIT(CHIPTOP_BANK,REG_EJ_MODE),           REG_EJ_MODE_MASK},
    {"EJ_MODE_2",       _RIUA_16BIT(CHIPTOP_BANK,REG_EJ_MODE),           REG_EJ_MODE_MASK},
    {"EJ_MODE_3",       _RIUA_16BIT(CHIPTOP_BANK,REG_EJ_MODE),           REG_EJ_MODE_MASK},
    {"TX_MIPI_MODE_1",  _RIUA_16BIT(CHIPTOP_BANK,REG_TX_MIPI_MODE),      REG_TX_MIPI_MODE_MASK},
    {"TX_MIPI_MODE_2",  _RIUA_16BIT(CHIPTOP_BANK,REG_TX_MIPI_MODE),      REG_TX_MIPI_MODE_MASK},
    {"TEST_IN_MODE_1",  _RIUA_16BIT(CHIPTOP_BANK,REG_TEST_IN_MODE),      REG_TEST_IN_MODE_MASK},
    {"TEST_IN_MODE_2",  _RIUA_16BIT(CHIPTOP_BANK,REG_TEST_IN_MODE),      REG_TEST_IN_MODE_MASK},
    {"TEST_IN_MODE_3",  _RIUA_16BIT(CHIPTOP_BANK,REG_TEST_IN_MODE),      REG_TEST_IN_MODE_MASK},
    {"TEST_OUT_MODE_1", _RIUA_16BIT(CHIPTOP_BANK,REG_TEST_OUT_MODE),     REG_TEST_OUT_MODE_MASK},
    {"TEST_OUT_MODE_2", _RIUA_16BIT(CHIPTOP_BANK,REG_TEST_OUT_MODE),     REG_TEST_OUT_MODE_MASK},
    {"TEST_OUT_MODE_3", _RIUA_16BIT(CHIPTOP_BANK,REG_TEST_OUT_MODE),     REG_TEST_OUT_MODE_MASK},
    {"I2C0_MODE_1",     _RIUA_16BIT(CHIPTOP_BANK,REG_I2C0_MODE),         REG_I2C0_MODE_MASK},
    {"I2C0_MODE_2",     _RIUA_16BIT(CHIPTOP_BANK,REG_I2C0_MODE),         REG_I2C0_MODE_MASK},
    {"I2C0_MODE_3",     _RIUA_16BIT(CHIPTOP_BANK,REG_I2C0_MODE),         REG_I2C0_MODE_MASK},
    {"I2C0_MODE_4",     _RIUA_16BIT(CHIPTOP_BANK,REG_I2C0_MODE),         REG_I2C0_MODE_MASK},
    {"I2C1_MODE_1",     _RIUA_16BIT(CHIPTOP_BANK,REG_I2C1_MODE),         REG_I2C1_MODE_MASK},
    {"I2C1_MODE_2",     _RIUA_16BIT(CHIPTOP_BANK,REG_I2C1_MODE),         REG_I2C1_MODE_MASK},
    {"I2C1_MODE_3",     _RIUA_16BIT(CHIPTOP_BANK,REG_I2C1_MODE),         REG_I2C1_MODE_MASK},
    {"I2C1_MODE_4",     _RIUA_16BIT(CHIPTOP_BANK,REG_I2C1_MODE),         REG_I2C1_MODE_MASK},
    {"I2C1_MODE_5",     _RIUA_16BIT(CHIPTOP_BANK,REG_I2C1_MODE),         REG_I2C1_MODE_MASK},
    {"PM_SPICZ2_MODE_1",_RIUA_16BIT(CHIPTOP_BANK,REG_PM_SPICZ2_MODE),    REG_PM_SPICZ2_MODE_MASK},
    {"PM_SPICZ2_MODE_2",_RIUA_16BIT(CHIPTOP_BANK,REG_PM_SPICZ2_MODE),    REG_PM_SPICZ2_MODE_MASK},
    {"SPI0_MODE_1",     _RIUA_16BIT(CHIPTOP_BANK,REG_SPI0_MODE),         REG_SPI0_MODE_MASK},
    {"SPI0_MODE_2",     _RIUA_16BIT(CHIPTOP_BANK,REG_SPI0_MODE),         REG_SPI0_MODE_MASK},
    {"SPI0_MODE_3",     _RIUA_16BIT(CHIPTOP_BANK,REG_SPI0_MODE),         REG_SPI0_MODE_MASK},
    {"SPI0_MODE_4",     _RIUA_16BIT(CHIPTOP_BANK,REG_SPI0_MODE),         REG_SPI0_MODE_MASK},
    {"SPI0_MODE_5",     _RIUA_16BIT(CHIPTOP_BANK,REG_SPI0_MODE),         REG_SPI0_MODE_MASK},
    {"SPI0_MODE_6",     _RIUA_16BIT(CHIPTOP_BANK,REG_SPI0_MODE),         REG_SPI0_MODE_MASK},
    {"FUART_MODE_1",    _RIUA_16BIT(CHIPTOP_BANK,REG_FUART_MODE),        REG_FUART_MODE_MASK},
    {"FUART_MODE_2",    _RIUA_16BIT(CHIPTOP_BANK,REG_FUART_MODE),        REG_FUART_MODE_MASK},
    {"FUART_MODE_3",    _RIUA_16BIT(CHIPTOP_BANK,REG_FUART_MODE),        REG_FUART_MODE_MASK},
    {"FUART_MODE_4",    _RIUA_16BIT(CHIPTOP_BANK,REG_FUART_MODE),        REG_FUART_MODE_MASK},
    {"FUART_MODE_5",    _RIUA_16BIT(CHIPTOP_BANK,REG_FUART_MODE),        REG_FUART_MODE_MASK},
    {"FUART_MODE_6",    _RIUA_16BIT(CHIPTOP_BANK,REG_FUART_MODE),        REG_FUART_MODE_MASK},
    {"FUART_MODE_7",    _RIUA_16BIT(CHIPTOP_BANK,REG_FUART_MODE),        REG_FUART_MODE_MASK},
    {"UART0_MODE_1",    _RIUA_16BIT(CHIPTOP_BANK,REG_UART0_MODE),        REG_UART0_MODE_MASK},
    {"UART0_MODE_2",    _RIUA_16BIT(CHIPTOP_BANK,REG_UART0_MODE),        REG_UART0_MODE_MASK},
    {"UART0_MODE_3",    _RIUA_16BIT(CHIPTOP_BANK,REG_UART0_MODE),        REG_UART0_MODE_MASK},
    {"UART0_MODE_4",    _RIUA_16BIT(CHIPTOP_BANK,REG_UART0_MODE),        REG_UART0_MODE_MASK},
    {"UART1_MODE_1",    _RIUA_16BIT(CHIPTOP_BANK,REG_UART1_MODE),        REG_UART1_MODE_MASK},
    {"UART1_MODE_2",    _RIUA_16BIT(CHIPTOP_BANK,REG_UART1_MODE),        REG_UART1_MODE_MASK},
    {"UART1_MODE_3",    _RIUA_16BIT(CHIPTOP_BANK,REG_UART1_MODE),        REG_UART1_MODE_MASK},
    {"UART1_MODE_4",    _RIUA_16BIT(CHIPTOP_BANK,REG_UART1_MODE),        REG_UART1_MODE_MASK},
    {"UART2_MODE_1",    _RIUA_16BIT(CHIPTOP_BANK,REG_UART2_MODE),        REG_UART2_MODE_MASK},
    {"UART2_MODE_2",    _RIUA_16BIT(CHIPTOP_BANK,REG_UART2_MODE),        REG_UART2_MODE_MASK},
    {"UART2_MODE_3",    _RIUA_16BIT(CHIPTOP_BANK,REG_UART2_MODE),        REG_UART2_MODE_MASK},
    {"UART2_MODE_4",    _RIUA_16BIT(CHIPTOP_BANK,REG_UART2_MODE),        REG_UART2_MODE_MASK},
    {"SDIO_MODE_1",     _RIUA_16BIT(CHIPTOP_BANK,REG_SDIO_MODE),         REG_SDIO_MODE_MASK},
    {"SDIO_MODE_2",     _RIUA_16BIT(CHIPTOP_BANK,REG_SDIO_MODE),         REG_SDIO_MODE_MASK},
    {"PWM0_MODE_1",     _RIUA_16BIT(CHIPTOP_BANK,REG_PWM0_MODE),         REG_PWM0_MODE_MASK},
    {"PWM0_MODE_2",     _RIUA_16BIT(CHIPTOP_BANK,REG_PWM0_MODE),         REG_PWM0_MODE_MASK},
    {"PWM0_MODE_3",     _RIUA_16BIT(CHIPTOP_BANK,REG_PWM0_MODE),         REG_PWM0_MODE_MASK},
    {"PWM0_MODE_4",     _RIUA_16BIT(CHIPTOP_BANK,REG_PWM0_MODE),         REG_PWM0_MODE_MASK},
    {"PWM0_MODE_5",     _RIUA_16BIT(CHIPTOP_BANK,REG_PWM0_MODE),         REG_PWM0_MODE_MASK},
    {"PWM1_MODE_1",     _RIUA_16BIT(CHIPTOP_BANK,REG_PWM1_MODE),         REG_PWM1_MODE_MASK},
    {"PWM1_MODE_2",     _RIUA_16BIT(CHIPTOP_BANK,REG_PWM1_MODE),         REG_PWM1_MODE_MASK},
    {"PWM1_MODE_3",     _RIUA_16BIT(CHIPTOP_BANK,REG_PWM1_MODE),         REG_PWM1_MODE_MASK},
    {"PWM1_MODE_4",     _RIUA_16BIT(CHIPTOP_BANK,REG_PWM1_MODE),         REG_PWM1_MODE_MASK},
    {"PWM1_MODE_5",     _RIUA_16BIT(CHIPTOP_BANK,REG_PWM1_MODE),         REG_PWM1_MODE_MASK},
    {"PWM2_MODE_1",     _RIUA_16BIT(CHIPTOP_BANK,REG_PWM2_MODE),         REG_PWM2_MODE_MASK},
    {"PWM2_MODE_2",     _RIUA_16BIT(CHIPTOP_BANK,REG_PWM2_MODE),         REG_PWM2_MODE_MASK},
    {"PWM2_MODE_3",     _RIUA_16BIT(CHIPTOP_BANK,REG_PWM2_MODE),         REG_PWM2_MODE_MASK},
    {"PWM2_MODE_4",     _RIUA_16BIT(CHIPTOP_BANK,REG_PWM2_MODE),         REG_PWM2_MODE_MASK},
    {"PWM2_MODE_5",     _RIUA_16BIT(CHIPTOP_BANK,REG_PWM2_MODE),         REG_PWM2_MODE_MASK},
    {"PWM2_MODE_6",     _RIUA_16BIT(CHIPTOP_BANK,REG_PWM2_MODE),         REG_PWM2_MODE_MASK},
    {"PWM3_MODE_1",     _RIUA_16BIT(CHIPTOP_BANK,REG_PWM3_MODE),         REG_PWM3_MODE_MASK},
    {"PWM3_MODE_2",     _RIUA_16BIT(CHIPTOP_BANK,REG_PWM3_MODE),         REG_PWM3_MODE_MASK},
    {"PWM3_MODE_3",     _RIUA_16BIT(CHIPTOP_BANK,REG_PWM3_MODE),         REG_PWM3_MODE_MASK},
    {"PWM3_MODE_4",     _RIUA_16BIT(CHIPTOP_BANK,REG_PWM3_MODE),         REG_PWM3_MODE_MASK},
    {"PWM3_MODE_5",     _RIUA_16BIT(CHIPTOP_BANK,REG_PWM3_MODE),         REG_PWM3_MODE_MASK},
    {"ETH0_MODE",       _RIUA_16BIT(CHIPTOP_BANK,REG_ETH0_MODE),         REG_ETH0_MODE_MASK},
    {"ETH1_MODE_1",     _RIUA_16BIT(CHIPTOP_BANK,REG_ETH1_MODE),         REG_ETH1_MODE_MASK},
    {"ETH1_MODE_2",     _RIUA_16BIT(CHIPTOP_BANK,REG_ETH1_MODE),         REG_ETH1_MODE_MASK},
    {"ETH1_MODE_3",     _RIUA_16BIT(CHIPTOP_BANK,REG_ETH1_MODE),         REG_ETH1_MODE_MASK},
    {"ETH1_MODE_4",     _RIUA_16BIT(CHIPTOP_BANK,REG_ETH1_MODE),         REG_ETH1_MODE_MASK},
    {"ETH1_MODE_5",     _RIUA_16BIT(CHIPTOP_BANK,REG_ETH1_MODE),         REG_ETH1_MODE_MASK},
    {"ETH1_MODE_6",     _RIUA_16BIT(CHIPTOP_BANK,REG_ETH1_MODE),         REG_ETH1_MODE_MASK},
    {"ETH1_MODE_7",     _RIUA_16BIT(CHIPTOP_BANK,REG_ETH1_MODE),         REG_ETH1_MODE_MASK},
    {"ETH1_MODE_8",     _RIUA_16BIT(CHIPTOP_BANK,REG_ETH1_MODE),         REG_ETH1_MODE_MASK},
    {"ETH1_MODE_9",     _RIUA_16BIT(CHIPTOP_BANK,REG_ETH1_MODE),         REG_ETH1_MODE_MASK},
    {"DMIC_MODE_1",     _RIUA_16BIT(CHIPTOP_BANK,REG_DMIC_MODE),         REG_DMIC_MODE_MASK},
    {"DMIC_MODE_2",     _RIUA_16BIT(CHIPTOP_BANK,REG_DMIC_MODE),         REG_DMIC_MODE_MASK},
    {"DMIC_MODE_3",     _RIUA_16BIT(CHIPTOP_BANK,REG_DMIC_MODE),         REG_DMIC_MODE_MASK},
    {"DMIC_MODE_4",     _RIUA_16BIT(CHIPTOP_BANK,REG_DMIC_MODE),         REG_DMIC_MODE_MASK},
    {"I2S_MODE_1",      _RIUA_16BIT(CHIPTOP_BANK,REG_I2S_MODE),          REG_I2S_MODE_MASK},
    {"I2S_MODE_2",      _RIUA_16BIT(CHIPTOP_BANK,REG_I2S_MODE),          REG_I2S_MODE_MASK},
    {"I2S_MODE_3",      _RIUA_16BIT(CHIPTOP_BANK,REG_I2S_MODE),          REG_I2S_MODE_MASK},
    {"TTL_MODE_1",      _RIUA_16BIT(CHIPTOP_BANK,REG_TTL_MODE),          REG_TTL_MODE_MASK},
    {"TTL_MODE_2",      _RIUA_16BIT(CHIPTOP_BANK,REG_TTL_MODE),          REG_TTL_MODE_MASK},
    {"TTL_MODE_3",      _RIUA_16BIT(CHIPTOP_BANK,REG_TTL_MODE),          REG_TTL_MODE_MASK},
    {"TTL_MODE_4",      _RIUA_16BIT(CHIPTOP_BANK,REG_TTL_MODE),          REG_TTL_MODE_MASK},
    {"TTL_MODE_5",      _RIUA_16BIT(CHIPTOP_BANK,REG_TTL_MODE),          REG_TTL_MODE_MASK},
    {"TTL_MODE_6",      _RIUA_16BIT(CHIPTOP_BANK,REG_TTL_MODE),          REG_TTL_MODE_MASK},
    {"TTL_MODE_7",      _RIUA_16BIT(CHIPTOP_BANK,REG_TTL_MODE),          REG_TTL_MODE_MASK},
    {"TTL_MODE_8",      _RIUA_16BIT(CHIPTOP_BANK,REG_TTL_MODE),          REG_TTL_MODE_MASK},
    {"TTL_MODE_9",      _RIUA_16BIT(CHIPTOP_BANK,REG_TTL_MODE),          REG_TTL_MODE_MASK},
    {"TTL_MODE_10",     _RIUA_16BIT(CHIPTOP_BANK,REG_TTL_MODE),          REG_TTL_MODE_MASK},
    {"TTL_MODE_11",     _RIUA_16BIT(CHIPTOP_BANK,REG_TTL_MODE),          REG_TTL_MODE_MASK},
    {"TTL_MODE_12",     _RIUA_16BIT(CHIPTOP_BANK,REG_TTL_MODE),          REG_TTL_MODE_MASK},
    {"TTL_MODE_13",     _RIUA_16BIT(CHIPTOP_BANK,REG_TTL_MODE),          REG_TTL_MODE_MASK},
    {"IDAC_MODE",       _RIUA_16BIT(CHIPTOP_BANK,REG_IDAC_MODE),         REG_IDAC_MODE_MASK},
    {"SATA_LED_MODE",   _RIUA_16BIT(CHIPTOP_BANK,REG_SATA_LED_MODE),     REG_SATA_LED_MODE_MASK},
    {"BT1120_MODE_1",   _RIUA_16BIT(CHIPTOP_BANK,REG_BT1120_MODE),       REG_BT1120_MODE_MASK},
    {"BT1120_MODE_2",   _RIUA_16BIT(CHIPTOP_BANK,REG_BT1120_MODE),       REG_BT1120_MODE_MASK},
    // PM Sleep
    {"PM_SPI_MODE",     _RIUA_16BIT(PMSLEEP_BANK,REG_PM_SPI_GPIO),       REG_PM_SPI_GPIO_MASK},
    {"PM_SPIWPN_MODE",  _RIUA_16BIT(PMSLEEP_BANK,REG_PM_SPIWPN_GPIO),    REG_PM_SPIWPN_GPIO_MASK},
    {"PM_SPIHOLDN_MODE",_RIUA_16BIT(PMSLEEP_BANK,REG_PM_SPIHOLDN_MODE),  REG_PM_SPIHOLDN_MODE_MASK},
    {"PM_SPICSZ1_MODE", _RIUA_16BIT(PMSLEEP_BANK,REG_PM_SPICSZ1_GPIO),   REG_PM_SPICSZ1_GPIO_MASK},
    {"PM_SPICSZ2_MODE", _RIUA_16BIT(PMSLEEP_BANK,REG_PM_SPICSZ2_GPIO),   REG_PM_SPICSZ2_GPIO_MASK},
    {"PM_PWM0_MODE",    _RIUA_16BIT(PMSLEEP_BANK,REG_PM_PWM0_MODE),      REG_PM_PWM0_MODE_MASK},
    {"PM_PWM1_MODE",    _RIUA_16BIT(PMSLEEP_BANK,REG_PM_PWM1_MODE),      REG_PM_PWM1_MODE_MASK},
    {"PM_PWM2_MODE",    _RIUA_16BIT(PMSLEEP_BANK,REG_PM_PWM2_MODE),      REG_PM_PWM2_MODE_MASK},
    {"PM_PWM3_MODE",    _RIUA_16BIT(PMSLEEP_BANK,REG_PM_PWM3_MODE),      REG_PM_PWM3_MODE_MASK},
    {"PM_UART1_MODE",   _RIUA_16BIT(PMSLEEP_BANK,REG_PM_UART1_MODE),     REG_PM_UART1_MODE_MASK},
    {"PM_VID_MODE_1",   _RIUA_16BIT(PMSLEEP_BANK,REG_PM_VID_MODE),       REG_PM_VID_MODE_MASK},
    {"PM_VID_MODE_2",   _RIUA_16BIT(PMSLEEP_BANK,REG_PM_VID_MODE),       REG_PM_VID_MODE_MASK},
    {"PM_VID_MODE_3",   _RIUA_16BIT(PMSLEEP_BANK,REG_PM_VID_MODE),       REG_PM_VID_MODE_MASK},
    {"PM_SD_CDZ_MODE",  _RIUA_16BIT(PMSLEEP_BANK,REG_PM_SD_CDZ_MODE),    REG_PM_SD_CDZ_MODE_MASK},
    {"PM_LED_MODE_1",   _RIUA_16BIT(PMSLEEP_BANK,REG_PM_LED_MODE),       REG_PM_LED_MODE_MASK},
    {"PM_LED_MODE_2",   _RIUA_16BIT(PMSLEEP_BANK,REG_PM_LED_MODE),       REG_PM_LED_MODE_MASK},
    {"PM_LED_MODE_3",   _RIUA_16BIT(PMSLEEP_BANK,REG_PM_LED_MODE),       REG_PM_LED_MODE_MASK},
    {"PM_IRIN_MODE",    _RIUA_16BIT(PMSLEEP_BANK,REG_PM_IR_IS_GPIO),     REG_PM_IR_IS_GPIO_MASK},
};
